/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.view.RouteDotGenerator;

public class DotViewTest
extends ContextTestSupport {
    protected String outputDirectory = "target/site/cameldoc";

    public void testGenerateFiles() throws Exception {
        RouteDotGenerator generator = new RouteDotGenerator(this.outputDirectory);
        generator.drawRoutes((CamelContext)this.context);
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyFooBean());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context.addRoutes((RoutesBuilder)new MulticastRoute());
        this.context.addRoutes((RoutesBuilder)new PipelineRoute());
        this.context.addRoutes((RoutesBuilder)new AnotherPipelineRoute());
        this.context.addRoutes((RoutesBuilder)new FromToRoute());
        this.context.addRoutes((RoutesBuilder)new ChoiceRoute());
        this.context.addRoutes((RoutesBuilder)new FilterRoute());
        this.context.addRoutes((RoutesBuilder)new ComplexRoute());
        this.context.addRoutes((RoutesBuilder)new FromToBeanRoute());
        this.context.addRoutes((RoutesBuilder)new RoutingSlipRoute());
        this.context.addRoutes((RoutesBuilder)new AggreagateRoute());
        this.context.addRoutes((RoutesBuilder)new ResequenceRoute());
    }

    static class ComplexRoute
    extends RouteBuilder {
        ComplexRoute() {
        }

        public void configure() throws Exception {
            this.from("file:target/xyz?noop=true").filter(this.header("foo").isEqualTo((Object)"bar")).recipientList((Expression)this.header("bar")).split((Expression)XPathBuilder.xpath((String)"/invoice/lineItems")).throttle(3L).to("mock:result");
        }
    }

    static class FilterRoute
    extends RouteBuilder {
        FilterRoute() {
        }

        public void configure() throws Exception {
            this.from("file:target/foo/bar?noop=true").filter(this.header("foo").isEqualTo((Object)"bar")).to("file:target/xyz?noop=true");
        }
    }

    static class ChoiceRoute
    extends RouteBuilder {
        ChoiceRoute() {
        }

        public void configure() throws Exception {
            ((ChoiceDefinition)this.from("file:target/foo/xyz?noop=true").choice().when((Predicate)this.xpath("/person/city = 'London'")).to("file:target/messages/uk")).otherwise().to("file:target/messages/others");
        }
    }

    static class ResequenceRoute
    extends RouteBuilder {
        ResequenceRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:foo5").resequence((Expression)this.constant("seqNum")).to("seda:bar");
        }
    }

    static class AggreagateRoute
    extends RouteBuilder {
        AggreagateRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:foo4").aggregate((Expression)this.constant("messageId"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(1000L).to("seda:aggregated");
        }
    }

    static class RoutingSlipRoute
    extends RouteBuilder {
        RoutingSlipRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:foo3").routingSlip((Expression)this.header("splipHeader"));
        }
    }

    static class FromToBeanRoute
    extends RouteBuilder {
        FromToBeanRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:foo2").beanRef("myBean", "hello");
        }
    }

    static class FromToRoute
    extends RouteBuilder {
        FromToRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:foo").to("seda:bar");
        }
    }

    static class AnotherPipelineRoute
    extends RouteBuilder {
        AnotherPipelineRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:pipeline.in2").pipeline(new String[]{"seda:pipeline.out1", "seda:pipeline.out2", "seda:pipeline.out3"});
        }
    }

    static class PipelineRoute
    extends RouteBuilder {
        PipelineRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:pipeline.in").to(new String[]{"seda:pipeline.out1", "seda:pipeline.out2", "seda:pipeline.out3"});
        }
    }

    static class MulticastRoute
    extends RouteBuilder {
        MulticastRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:multicast.in").multicast().to(new String[]{"seda:multicast.out1", "seda:multicast.out2", "seda:multicast.out3"});
        }
    }
}

