/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kura;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KuraRouter
extends RouteBuilder
implements BundleActivator {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected BundleContext bundleContext;
    protected CamelContext camelContext;
    protected ProducerTemplate producerTemplate;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.log.debug("Initializing bundle {}.", (Object)bundleContext.getBundle().getBundleId());
        this.camelContext = this.createCamelContext();
        this.camelContext.addRoutes((RoutesBuilder)this);
        this.beforeStart(this.camelContext);
        this.camelContext.start();
        this.producerTemplate = this.camelContext.createProducerTemplate();
        this.log.debug("Bundle {} started.", (Object)bundleContext.getBundle().getBundleId());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.log.debug("Stopping bundle {}.", (Object)bundleContext.getBundle().getBundleId());
        this.camelContext.stop();
        this.log.debug("Bundle {} stopped.", (Object)bundleContext.getBundle().getBundleId());
    }

    protected CamelContext createCamelContext() {
        return new OsgiDefaultCamelContext(this.bundleContext);
    }

    protected void beforeStart(CamelContext camelContext) {
        this.log.debug("Empty KuraRouter CamelContext before start configuration - skipping.");
    }

    protected <T> T service(Class<T> serviceType) {
        ServiceReference reference = this.bundleContext.getServiceReference(serviceType);
        return (T)this.bundleContext.getService(reference);
    }
}

