/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.service.GitHubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCommitFileProducer
extends AbstractGitHubProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(GetCommitFileProducer.class);
    private DataService dataService;
    private String encoding = "utf-8";

    public GetCommitFileProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubDataService");
        if (service != null) {
            LOG.debug("Using DataService found in registry " + service.getClass().getCanonicalName());
            this.dataService = (DataService)service;
        } else {
            this.dataService = new DataService();
        }
        this.initService((GitHubService)this.dataService);
        if (endpoint.getEncoding() != null) {
            this.encoding = endpoint.getEncoding();
            if (!this.encoding.equalsIgnoreCase("base64") && !this.encoding.equalsIgnoreCase("utf-8")) {
                throw new IllegalArgumentException("Unknown encoding '" + this.encoding + "'");
            }
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        CommitFile file = (CommitFile)exchange.getIn().getBody(CommitFile.class);
        Blob response = this.dataService.getBlob((IRepositoryIdProvider)this.getRepository(), file.getSha());
        String text = response.getContent();
        if (response.getEncoding().equals("base64") && this.encoding != null && this.encoding.equalsIgnoreCase("utf-8")) {
            text = new String(Base64.decodeBase64((String)text));
        }
        exchange.getOut().copyFrom(exchange.getIn());
        exchange.getOut().setBody((Object)text);
    }
}

