/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.MessageRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppMessage
extends DefaultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(SmppMessage.class);
    private Command command;
    private SmppConfiguration configuration;

    public SmppMessage(SmppConfiguration configuration) {
        this.configuration = configuration;
    }

    public SmppMessage(AlertNotification command, SmppConfiguration configuration) {
        this.command = command;
        this.configuration = configuration;
    }

    public SmppMessage(DeliverSm command, SmppConfiguration configuration) {
        this.command = command;
        this.configuration = configuration;
    }

    public SmppMessage(DataSm dataSm, SmppConfiguration configuration) {
        this.command = dataSm;
        this.configuration = configuration;
    }

    public SmppMessage newInstance() {
        return new SmppMessage(this.configuration);
    }

    public boolean isAlertNotification() {
        return this.command instanceof AlertNotification;
    }

    public boolean isDataSm() {
        return this.command instanceof DataSm;
    }

    public boolean isDeliverSm() {
        return this.command instanceof DeliverSm && !((DeliverSm)this.command).isSmscDeliveryReceipt();
    }

    public boolean isDeliveryReceipt() {
        return this.command instanceof DeliverSm && ((DeliverSm)this.command).isSmscDeliveryReceipt();
    }

    protected Object createBody() {
        if (this.command instanceof MessageRequest) {
            MessageRequest msgRequest = (MessageRequest)this.command;
            byte[] shortMessage = msgRequest.getShortMessage();
            if (shortMessage == null || shortMessage.length == 0) {
                return null;
            }
            if (SmppUtils.parseAlphabetFromDataCoding(msgRequest.getDataCoding()) == Alphabet.ALPHA_8_BIT) {
                return shortMessage;
            }
            String encoding = IOHelper.getCharsetName((Exchange)this.getExchange(), (boolean)false);
            if (ObjectHelper.isEmpty((Object)encoding) || !Charset.isSupported(encoding)) {
                encoding = this.configuration.getEncoding();
            }
            try {
                return new String(shortMessage, encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.info("Unsupported encoding \"{}\". Using system default encoding.", (Object)encoding);
                return new String(shortMessage);
            }
        }
        return null;
    }

    public String toString() {
        if (this.command != null) {
            return "SmppMessage: " + this.command;
        }
        return "SmppMessage: " + this.getBody();
    }

    public Command getCommand() {
        return this.command;
    }
}

