/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConnectionFactory;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.PDUComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SmppProducer.class);
    private SmppConfiguration configuration;
    private SMPPSession session;
    private SessionStateListener internalSessionStateListener;
    private final ReentrantLock connectLock = new ReentrantLock();

    public SmppProducer(SmppEndpoint endpoint, SmppConfiguration config) {
        super((Endpoint)endpoint);
        this.configuration = config;
        this.internalSessionStateListener = new SessionStateListener(){

            public void onStateChange(SessionState newState, SessionState oldState, Object source) {
                if (SmppProducer.this.configuration.getSessionStateListener() != null) {
                    SmppProducer.this.configuration.getSessionStateListener().onStateChange(newState, oldState, source);
                }
                if (newState.equals((Object)SessionState.CLOSED)) {
                    LOG.warn("Lost connection to: {} - trying to reconnect...", (Object)SmppProducer.this.getEndpoint().getConnectionString());
                    SmppProducer.this.closeSession();
                    SmppProducer.this.reconnect(SmppProducer.this.configuration.getInitialReconnectDelay());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        super.doStart();
        if (!this.getConfiguration().isLazySessionCreation() && this.connectLock.tryLock()) {
            try {
                this.session = this.createSession();
            }
            finally {
                this.connectLock.unlock();
            }
        }
    }

    private SMPPSession createSession() throws IOException {
        LOG.debug("Connecting to: " + this.getEndpoint().getConnectionString() + "...");
        SMPPSession session = this.createSMPPSession();
        session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        session.addSessionStateListener(this.internalSessionStateListener);
        session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_TX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.valueOf((byte)this.configuration.getTypeOfNumber()), NumberingPlanIndicator.valueOf((byte)this.configuration.getNumberingPlanIndicator()), ""));
        LOG.info("Connected to: " + this.getEndpoint().getConnectionString());
        return session;
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession((PDUSender)new SynchronizedPDUSender((PDUSender)new DefaultPDUSender((PDUComposer)new DefaultComposer())), (PDUReader)new DefaultPDUReader(), (ConnectionFactory)SmppConnectionFactory.getInstance(this.configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        if (this.session == null && this.configuration.isLazySessionCreation() && this.connectLock.tryLock()) {
            try {
                if (this.session == null) {
                    Message in = exchange.getIn();
                    String systemId = (String)in.getHeader("CamelSmppSystemId", String.class);
                    String password = (String)in.getHeader("CamelSmppPassword", String.class);
                    if (systemId != null && password != null) {
                        this.log.info("using the system id '{}' to connect to the SMSC...", (Object)systemId);
                        this.configuration.setSystemId(systemId);
                        this.configuration.setPassword(password);
                    }
                    this.session = this.createSession();
                }
            }
            finally {
                this.connectLock.unlock();
            }
        }
        if (this.session == null) {
            throw new IOException("Lost connection to " + this.getEndpoint().getConnectionString() + " and yet not reconnected");
        }
        SmppCommand command = this.getEndpoint().getBinding().createSmppCommand(this.session, exchange);
        command.execute(exchange);
    }

    protected void doStop() throws Exception {
        LOG.debug("Disconnecting from: " + this.getEndpoint().getConnectionString() + "...");
        super.doStop();
        this.closeSession();
        LOG.info("Disconnected from: " + this.getEndpoint().getConnectionString());
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.removeSessionStateListener(this.internalSessionStateListener);
            try {
                Thread.sleep(1000L);
                this.session.unbindAndClose();
            }
            catch (Exception e) {
                LOG.warn("Could not close session " + this.session);
            }
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(final long initialReconnectDelay) {
        if (this.connectLock.tryLock()) {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        boolean reconnected = false;
                        LOG.info("Schedule reconnect after " + initialReconnectDelay + " millis");
                        try {
                            Thread.sleep(initialReconnectDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        int attempt = 0;
                        while (!(SmppProducer.this.isStopping() || SmppProducer.this.isStopped() || SmppProducer.this.session != null && !SmppProducer.this.session.getSessionState().equals((Object)SessionState.CLOSED))) {
                            try {
                                LOG.info("Trying to reconnect to " + SmppProducer.this.getEndpoint().getConnectionString() + " - attempt #" + ++attempt + "...");
                                SmppProducer.this.session = SmppProducer.this.createSession();
                                reconnected = true;
                            }
                            catch (IOException e) {
                                LOG.info("Failed to reconnect to " + SmppProducer.this.getEndpoint().getConnectionString());
                                SmppProducer.this.closeSession();
                                try {
                                    Thread.sleep(SmppProducer.this.configuration.getReconnectDelay());
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        if (reconnected) {
                            LOG.info("Reconnected to " + SmppProducer.this.getEndpoint().getConnectionString());
                        }
                    }
                };
                Thread t = new Thread(r);
                t.start();
                t.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.connectLock.unlock();
            }
        }
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "SmppProducer[" + this.getEndpoint().getConnectionString() + "]";
    }
}

