/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox.seda;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.routebox.RouteboxProducer;
import org.apache.camel.component.routebox.seda.RouteboxSedaEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.ExchangeHelper;

public class RouteboxSedaProducer
extends DefaultAsyncProducer
implements RouteboxProducer {
    protected final Collection<Exchange> queue;
    private final RouteboxSedaEndpoint endpoint;
    private final WaitForTaskToComplete waitForTaskToComplete;
    private final long timeout;

    public RouteboxSedaProducer(RouteboxSedaEndpoint endpoint, BlockingQueue<Exchange> queue, WaitForTaskToComplete waitForTaskToComplete, long timeout) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.queue = queue;
        this.waitForTaskToComplete = waitForTaskToComplete;
        this.timeout = timeout;
    }

    public boolean process(final Exchange exchange, AsyncCallback callback) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)true);
        copy.setFromEndpoint((Endpoint)this.endpoint);
        WaitForTaskToComplete wait = this.waitForTaskToComplete;
        if (exchange.getProperty("CamelAsyncWait") != null) {
            wait = (WaitForTaskToComplete)exchange.getProperty("CamelAsyncWait", WaitForTaskToComplete.class);
        }
        if (wait == WaitForTaskToComplete.Always || wait == WaitForTaskToComplete.IfReplyExpected && ExchangeHelper.isOutCapable((Exchange)exchange)) {
            final CountDownLatch latch = new CountDownLatch(1);
            copy.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onDone(Exchange response) {
                    if (latch.getCount() == 0L) {
                        if (RouteboxSedaProducer.this.log.isTraceEnabled()) {
                            RouteboxSedaProducer.this.log.trace("{}. Timeout occurred so response will be ignored: {}", (Object)this, (Object)(response.hasOut() ? response.getOut() : response.getIn()));
                        }
                        return;
                    }
                    if (RouteboxSedaProducer.this.log.isTraceEnabled()) {
                        RouteboxSedaProducer.this.log.trace("{} with response: {}", (Object)this, (Object)(response.hasOut() ? response.getOut() : response.getIn()));
                    }
                    try {
                        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)response);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                public boolean allowHandover() {
                    return false;
                }

                public String toString() {
                    return "onDone at [" + RouteboxSedaProducer.this.endpoint.getEndpointUri() + "]";
                }
            });
            this.queue.add(copy);
            if (this.timeout > 0L) {
                this.log.trace("Waiting for task to complete using timeout (ms): {} at [{}]", (Object)this.timeout, (Object)this.endpoint.getEndpointUri());
                boolean done = false;
                try {
                    done = latch.await(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!done) {
                    exchange.setException((Throwable)new ExchangeTimedOutException(exchange, this.timeout));
                    latch.countDown();
                }
            } else {
                this.log.trace("Waiting for task to complete (blocking) at [{}]", (Object)this.endpoint.getEndpointUri());
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.queue.add(copy);
        }
        callback.done(true);
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.onStarted(this);
    }

    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        super.doStop();
    }
}

