/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.javaspace;

import java.io.File;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jini.space.JavaSpace;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.javaspace.JavaSpaceEndpoint;
import org.apache.camel.component.javaspace.JiniSpaceAccessor;
import org.apache.camel.component.javaspace.Task;
import org.apache.camel.component.javaspace.TransactionHelper;
import org.apache.camel.component.javaspace.Utility;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSpaceConsumer
extends DefaultConsumer {
    public static final int READ = 1;
    public static final int TAKE = 0;
    private static final Logger LOG = LoggerFactory.getLogger(JavaSpaceConsumer.class);
    private final int concurrentConsumers;
    private final boolean transactional;
    private final long transactionTimeout;
    private final String verb;
    private final String templateId;
    private final ScheduledThreadPoolExecutor executor;
    private JavaSpace javaSpace;
    private TransactionHelper transactionHelper;

    public JavaSpaceConsumer(JavaSpaceEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.concurrentConsumers = endpoint.getConcurrentConsumers();
        this.transactional = endpoint.isTransactional();
        this.transactionTimeout = endpoint.getTransactionTimeout();
        this.verb = endpoint.getVerb();
        this.templateId = endpoint.getTemplateId();
        this.executor = new ScheduledThreadPoolExecutor(this.concurrentConsumers);
    }

    protected void doStart() throws Exception {
        Utility.setSecurityPolicy("policy.all", "policy_consumer.all");
        int verb = 0;
        if (this.verb.equalsIgnoreCase("read")) {
            verb = 1;
        }
        this.javaSpace = JiniSpaceAccessor.findSpace(((JavaSpaceEndpoint)this.getEndpoint()).getUrl(), ((JavaSpaceEndpoint)this.getEndpoint()).getSpaceName());
        if (this.transactional) {
            this.transactionHelper = TransactionHelper.getInstance(((JavaSpaceEndpoint)this.getEndpoint()).getUrl());
        }
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            Task worker = new Task((JavaSpaceEndpoint)this.getEndpoint(), this.getProcessor(), this.javaSpace, this.transactionHelper, this.transactionTimeout, verb, this.templateId);
            this.executor.scheduleWithFixedDelay(worker, 0L, 1L, TimeUnit.NANOSECONDS);
        }
        new File("policy_consumer.all").delete();
    }

    protected void doStop() throws Exception {
        this.executor.shutdown();
    }
}

