/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppBinding {
    private static final Logger LOG = LoggerFactory.getLogger(XmppBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public XmppBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public XmppBinding(HeaderFilterStrategy headerFilterStrategy) {
        ObjectHelper.notNull((Object)headerFilterStrategy, (String)"headerFilterStrategy");
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void populateXmppMessage(Message message, Exchange exchange) {
        message.setBody((String)exchange.getIn().getBody(String.class));
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value;
            String name = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(name, value = entry.getValue(), exchange)) continue;
            if ("subject".equalsIgnoreCase(name)) {
                String subject = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setSubject(subject);
                continue;
            }
            if ("language".equalsIgnoreCase(name)) {
                String language = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setLanguage(language);
                continue;
            }
            try {
                JivePropertiesManager.addProperty((Packet)message, (String)name, value);
                LOG.trace("Added property name: {} value: {}", (Object)name, (Object)value.toString());
            }
            catch (IllegalArgumentException iae) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Cannot add property " + name + " to XMPP message due: ", (Throwable)iae);
            }
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            JivePropertiesManager.addProperty((Packet)message, (String)"exchangeId", (Object)id);
        }
    }

    public void populateXmppPacket(Packet packet, Exchange exchange) {
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value;
            String name = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(name, value = entry.getValue(), exchange)) continue;
            try {
                JivePropertiesManager.addProperty((Packet)packet, (String)name, value);
                LOG.debug("Added property name: " + name + " value: " + value.toString());
            }
            catch (IllegalArgumentException iae) {
                LOG.debug("Not adding property " + name + " to XMPP message due to " + iae);
            }
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            JivePropertiesManager.addProperty((Packet)packet, (String)"exchangeId", (Object)id);
        }
    }

    public Object extractBodyFromXmpp(Exchange exchange, Packet xmppPacket) {
        return xmppPacket instanceof Message ? this.getMessageBody((Message)xmppPacket) : xmppPacket;
    }

    private Object getMessageBody(Message message) {
        String messageBody = message.getBody();
        if (messageBody == null) {
            return message;
        }
        return messageBody;
    }

    public Map<String, Object> extractHeadersFromXmpp(Packet xmppPacket, Exchange exchange) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String name : JivePropertiesManager.getPropertiesNames((Packet)xmppPacket)) {
            Object value;
            if (this.headerFilterStrategy.applyFilterToExternalHeaders(name, value = JivePropertiesManager.getProperty((Packet)xmppPacket, (String)name), exchange)) continue;
            answer.put(name, value);
        }
        if (xmppPacket instanceof Message) {
            Message xmppMessage = (Message)xmppPacket;
            answer.put("CamelXmppMessageType", xmppMessage.getType());
            answer.put("CamelXmppSubject", xmppMessage.getSubject());
            answer.put("CamelXmppThreadID", xmppMessage.getThread());
        } else if (xmppPacket instanceof PubSub) {
            PubSub pubsubPacket = (PubSub)xmppPacket;
            answer.put("CamelXmppMessageType", pubsubPacket.getType());
        }
        answer.put("CamelXmppFrom", xmppPacket.getFrom());
        answer.put("CamelXmppPacketID", xmppPacket.getPacketID());
        answer.put("CamelXmppTo", xmppPacket.getTo());
        return answer;
    }
}

