/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.component.xmpp.XmppPrivateChatProducer;
import org.apache.camel.impl.DefaultProducer;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppPubSubProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(XmppPrivateChatProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPConnection connection;

    public XmppPubSubProducer(XmppEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        LOG.debug("Creating XmppPresenceProducer");
    }

    public void process(Exchange exchange) throws Exception {
        try {
            if (this.connection == null) {
                this.connection = this.endpoint.createConnection();
            }
            if (!this.connection.isConnected()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reconnecting to: " + XmppEndpoint.getConnectionMessage(this.connection));
                }
                this.connection.connect();
            }
        }
        catch (XMPPException e) {
            throw new RuntimeExchangeException("Cannot connect to XMPP Server: " + (this.connection != null ? XmppEndpoint.getConnectionMessage(this.connection) : this.endpoint.getHost()), exchange, (Throwable)e);
        }
        try {
            Object body = exchange.getIn().getBody(Object.class);
            if (!(body instanceof PubSub)) {
                throw new Exception("Message does not contain a pubsub packet");
            }
            PubSub pubsubpacket = (PubSub)body;
            this.endpoint.getBinding().populateXmppPacket((Packet)pubsubpacket, exchange);
            exchange.getIn().setHeader("CamelXmppDoc", (Object)pubsubpacket);
            this.connection.sendPacket((Packet)pubsubpacket);
        }
        catch (XMPPException xmppe) {
            throw new RuntimeExchangeException("Cannot send XMPP pubsub: from " + this.endpoint.getUser() + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, (Throwable)xmppe);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot send XMPP pubsub: from " + this.endpoint.getUser() + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, (Throwable)e);
        }
    }
}

