/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.MessageSupport;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public final class DefaultExchange
implements Exchange {
    protected final CamelContext context;
    private Map<String, Object> properties;
    private Message in;
    private Message out;
    private Exception exception;
    private String exchangeId;
    private UnitOfWork unitOfWork;
    private ExchangePattern pattern;
    private Endpoint fromEndpoint;
    private String fromRouteId;
    private List<Synchronization> onCompletions;

    public DefaultExchange(CamelContext context) {
        this(context, ExchangePattern.InOnly);
    }

    public DefaultExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
    }

    public DefaultExchange(Exchange parent) {
        this(parent.getContext(), parent.getPattern());
        this.fromEndpoint = parent.getFromEndpoint();
        this.fromRouteId = parent.getFromRouteId();
        this.unitOfWork = parent.getUnitOfWork();
    }

    public DefaultExchange(Endpoint fromEndpoint) {
        this(fromEndpoint, ExchangePattern.InOnly);
    }

    public DefaultExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        this(fromEndpoint.getCamelContext(), pattern);
        this.fromEndpoint = fromEndpoint;
    }

    public String toString() {
        return "Exchange[" + (this.out == null ? this.in : this.out) + "]";
    }

    @Override
    public Exchange copy() {
        DefaultExchange exchange = new DefaultExchange(this);
        if (this.hasProperties()) {
            exchange.setProperties(DefaultExchange.safeCopy(this.getProperties()));
        }
        exchange.setIn(this.getIn().copy());
        if (this.hasOut()) {
            exchange.setOut(this.getOut().copy());
        }
        exchange.setException(this.getException());
        return exchange;
    }

    private static Map<String, Object> safeCopy(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        ConcurrentHashMap<String, Object> answer = new ConcurrentHashMap<String, Object>(properties);
        List history = (List)answer.remove("CamelMessageHistory");
        if (history != null) {
            answer.put("CamelMessageHistory", new ArrayList(history));
        }
        return answer;
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        Object answer = this.getProperty(name);
        return answer != null ? answer : defaultValue;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    @Override
    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name, defaultValue);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (value != null) {
            this.getProperties().put(name, value);
        } else if (name != null) {
            this.getProperties().remove(name);
        }
    }

    @Override
    public Object removeProperty(String name) {
        if (!this.hasProperties()) {
            return null;
        }
        return this.getProperties().remove(name);
    }

    @Override
    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    @Override
    public boolean removeProperties(String pattern, String ... excludePatterns) {
        if (!this.hasProperties()) {
            return false;
        }
        boolean matches = false;
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (!EndpointHelper.matchPattern(key, pattern) || excludePatterns != null && DefaultExchange.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            this.properties.remove(entry.getKey());
        }
        return matches;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>();
        }
        return this.properties;
    }

    @Override
    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage();
            this.configureMessage(this.in);
        }
        return this.in;
    }

    @Override
    public <T> T getIn(Class<T> type) {
        Message in = this.getIn();
        if (type.isInstance(in)) {
            return type.cast(in);
        }
        return this.context.getTypeConverter().convertTo(type, this, in);
    }

    @Override
    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    @Override
    public Message getOut() {
        if (this.out == null) {
            this.out = this.in != null && this.in instanceof MessageSupport ? ((MessageSupport)this.in).newInstance() : new DefaultMessage();
            this.configureMessage(this.out);
        }
        return this.out;
    }

    @Override
    public <T> T getOut(Class<T> type) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type.isInstance(out)) {
            return type.cast(out);
        }
        return this.context.getTypeConverter().convertTo(type, this, out);
    }

    @Override
    public boolean hasOut() {
        return this.out != null;
    }

    @Override
    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public <T> T getException(Class<T> type) {
        return ObjectHelper.getException(type, this.exception);
    }

    @Override
    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : ObjectHelper.wrapCamelExecutionException(this, t));
    }

    @Override
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    @Override
    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    @Override
    public String getFromRouteId() {
        return this.fromRouteId;
    }

    @Override
    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    @Override
    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    @Override
    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    @Override
    public boolean isFailed() {
        if (this.exception != null) {
            return true;
        }
        return this.hasOut() ? this.getOut().isFault() : this.getIn().isFault();
    }

    @Override
    public boolean isTransacted() {
        UnitOfWork uow = this.getUnitOfWork();
        if (uow != null) {
            return uow.isTransacted();
        }
        return false;
    }

    @Override
    public Boolean isExternalRedelivered() {
        DefaultMessage msg;
        Boolean answer = null;
        if (this.hasProperties()) {
            answer = this.getProperty("CamelExternalRedelivered", null, Boolean.class);
        }
        if (answer == null && (msg = this.getIn(DefaultMessage.class)) != null) {
            answer = msg.isTransactedRedelivered();
            this.setProperty("CamelExternalRedelivered", answer);
        }
        return answer;
    }

    @Override
    public boolean isRollbackOnly() {
        return Boolean.TRUE.equals(this.getProperty("CamelRollbackOnly")) || Boolean.TRUE.equals(this.getProperty("CamelRollbackOnlyLast"));
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    @Override
    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (unitOfWork != null && this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    @Override
    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.getUnitOfWork().addSynchronization(onCompletion);
        }
    }

    @Override
    public boolean containsOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork != null) {
            return this.unitOfWork.containsSynchronization(onCompletion);
        }
        return this.onCompletions != null && this.onCompletions.contains(onCompletion);
    }

    @Override
    public void handoverCompletions(Exchange target) {
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                target.addOnCompletion(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        } else if (this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(target);
        }
    }

    @Override
    public List<Synchronization> handoverCompletions() {
        ArrayList<Synchronization> answer = null;
        if (this.onCompletions != null) {
            answer = new ArrayList<Synchronization>(this.onCompletions);
            this.onCompletions.clear();
            this.onCompletions = null;
        }
        return answer;
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
        }
    }

    protected String createExchangeId() {
        String answer = null;
        if (this.in != null) {
            answer = this.in.createExchangeId();
        }
        if (answer == null) {
            answer = this.context.getUuidGenerator().generateUuid();
        }
        return answer;
    }

    private static boolean isExcludePatternMatch(String key, String ... excludePatterns) {
        for (String pattern : excludePatterns) {
            if (!EndpointHelper.matchPattern(key, pattern)) continue;
            return true;
        }
        return false;
    }
}

