/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron;

import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.schematron.SchematronEndpoint;
import org.apache.camel.component.schematron.exception.SchematronValidationException;
import org.apache.camel.component.schematron.processor.SchematronProcessorFactory;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronProducer
extends DefaultProducer {
    private Logger logger = LoggerFactory.getLogger(SchematronProducer.class);
    private SchematronEndpoint endpoint;

    public SchematronProducer(SchematronEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String payload = (String)exchange.getIn().getBody(String.class);
        this.logger.debug("Applying schematron validation on payload: {}", (Object)payload);
        String report = SchematronProcessorFactory.newScehamtronEngine(this.endpoint.getRules()).validate(payload);
        this.logger.debug("Schematron validation report \n {}", (Object)report);
        String status = this.getValidationStatus(report);
        this.logger.info("Schematron validation status : {}", (Object)status);
        this.setValidationReport(exchange, report, status);
    }

    private void setValidationReport(Exchange exchange, String report, String status) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelSchematronValidationStatus", status);
        headers.put("CamelSchematronValidationReport", report);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
            exchange.getOut().getHeaders().putAll(headers);
        } else {
            exchange.getIn().getHeaders().putAll(headers);
        }
    }

    private String getValidationStatus(String report) {
        String status;
        String string = status = report.contains("failed-assert") ? "FAILED" : "SUCCESS";
        if (this.endpoint.isAbort() && "FAILED".equals(status)) {
            throw new SchematronValidationException("Schematron validation failure \n" + report);
        }
        return status;
    }
}

