/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ssh.ResourceHelperKeyPairProvider;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.component.ssh.SshResult;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(SshHelper.class);

    private SshHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshResult sendExecCommand(String command, SshEndpoint endpoint, SshClient client) throws Exception {
        SshResult result = null;
        SshConfiguration configuration = endpoint.getConfiguration();
        if (configuration == null) {
            throw new IllegalStateException("Configuration must be set");
        }
        ConnectFuture connectFuture = client.connect(null, configuration.getHost(), configuration.getPort());
        connectFuture.await(configuration.getTimeout());
        if (!connectFuture.isDone() || !connectFuture.isConnected()) {
            String msg = "Failed to connect to " + configuration.getHost() + ":" + configuration.getPort() + " within timeout " + configuration.getTimeout() + "ms";
            LOG.debug(msg);
            throw new RuntimeCamelException(msg);
        }
        LOG.debug("Connected to {}:{}", (Object)configuration.getHost(), (Object)configuration.getPort());
        ClientChannel channel = null;
        ClientSession session = null;
        try {
            AuthFuture authResult;
            Object keyPairProvider;
            session = connectFuture.getSession();
            String certResource = configuration.getCertResource();
            if (certResource != null) {
                LOG.debug("Attempting to authenticate using ResourceKey '{}'...", (Object)certResource);
                keyPairProvider = new ResourceHelperKeyPairProvider(new String[]{certResource}, endpoint.getCamelContext().getClassResolver());
            } else {
                keyPairProvider = configuration.getKeyPairProvider();
            }
            if (keyPairProvider != null) {
                LOG.debug("Attempting to authenticate username '{}' using Key...", (Object)configuration.getUsername());
                KeyPair pair = keyPairProvider.loadKey(configuration.getKeyType());
                authResult = session.authPublicKey(configuration.getUsername(), pair);
            } else {
                LOG.debug("Attempting to authenticate username '{}' using Password...", (Object)configuration.getUsername());
                authResult = session.authPassword(configuration.getUsername(), configuration.getPassword());
            }
            authResult.await(configuration.getTimeout());
            if (!authResult.isDone() || authResult.isFailure()) {
                LOG.debug("Failed to authenticate");
                throw new RuntimeCamelException("Failed to authenticate username " + configuration.getUsername());
            }
            channel = session.createChannel("exec", command);
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{0});
            channel.setIn((InputStream)in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            channel.setOut((OutputStream)out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            channel.setErr((OutputStream)err);
            OpenFuture openFuture = channel.open();
            openFuture.await(configuration.getTimeout());
            if (openFuture.isOpened()) {
                channel.waitFor(2, 0L);
                result = new SshResult(command, channel.getExitStatus(), new ByteArrayInputStream(out.toByteArray()), new ByteArrayInputStream(err.toByteArray()));
            }
            SshResult sshResult = result;
            return sshResult;
        }
        finally {
            if (channel != null) {
                channel.close(true);
            }
            if (session != null) {
                session.close(false);
            }
        }
    }
}

