/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmlrpc.XmlRpcClientConfigurer;
import org.apache.camel.component.xmlrpc.XmlRpcComponent;
import org.apache.camel.component.xmlrpc.XmlRpcConfiguration;
import org.apache.camel.component.xmlrpc.XmlRpcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

@UriEndpoint(scheme="xmlrpc", title="XML RPC", syntax="xmlrpc:address", producerOnly=true, label="transformation")
public class XmlRpcEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private String address;
    @UriParam
    private XmlRpcConfiguration configuration;
    @UriParam
    private String defaultMethodName;
    @UriParam
    private XmlRpcClientConfigurer clientConfigurer;
    @UriParam
    private XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();

    public XmlRpcEndpoint() {
    }

    public XmlRpcEndpoint(String uri, XmlRpcComponent component, String address) {
        super(uri, (Component)component);
        this.setAddress(address);
    }

    public Producer createProducer() throws Exception {
        XmlRpcProducer answer = new XmlRpcProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("This component does not support consuming from this endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    public XmlRpcClient createClient() throws MalformedURLException {
        XmlRpcClient client = new XmlRpcClient();
        XmlRpcClientConfigImpl config = this.clientConfig.cloneMe();
        config.setServerURL(new URL(this.getAddress()));
        client.setConfig((XmlRpcClientConfig)config);
        if (this.clientConfigurer != null) {
            this.clientConfigurer.configureXmlRpcClient(client);
        }
        return client;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public XmlRpcClientConfigurer getClientConfigurer() {
        return this.clientConfigurer;
    }

    public void setClientConfigurer(XmlRpcClientConfigurer configurer) {
        this.clientConfigurer = configurer;
    }

    public void setClientConfig(XmlRpcClientConfigImpl config) {
        this.clientConfig = config;
    }

    public XmlRpcClientConfigImpl getClientConfig() {
        return this.clientConfig;
    }

    public String getDefaultMethodName() {
        return this.defaultMethodName;
    }

    public void setDefaultMethodName(String defaultMethodName) {
        this.defaultMethodName = defaultMethodName;
    }

    public XmlRpcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(XmlRpcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.clientConfig == null) {
            this.clientConfig = new XmlRpcClientConfigImpl();
        }
        HashMap params = new HashMap();
        IntrospectionSupport.getProperties((Object)this.configuration, params, null);
        this.setProperties(this.clientConfig, params);
    }
}

