/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.camel.CamelContext;
import org.apache.camel.cdi.CdiCamelContext;
import org.apache.camel.cdi.internal.CamelContextConfig;
import org.apache.camel.util.ObjectHelper;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.api.literal.DefaultLiteral;

public class CamelContextBean
implements Bean<CdiCamelContext> {
    private final BeanManager beanManager;
    private final String name;
    private final String camelContextName;
    private final InjectionTarget<CdiCamelContext> target;
    private final CamelContextConfig config;

    public CamelContextBean(BeanManager beanManager) {
        this(beanManager, "CamelContext", "", new CamelContextConfig());
    }

    public CamelContextBean(BeanManager beanManager, String name, String camelContextName, CamelContextConfig config) {
        this.beanManager = beanManager;
        this.name = name;
        this.camelContextName = camelContextName;
        this.config = config;
        this.target = beanManager.createInjectionTarget(beanManager.createAnnotatedType(CdiCamelContext.class));
    }

    public CdiCamelContext create(CreationalContext<CdiCamelContext> context) {
        CdiCamelContext camelContext = (CdiCamelContext)((Object)this.target.produce(context));
        if (ObjectHelper.isNotEmpty((Object)this.camelContextName)) {
            camelContext.setName(this.camelContextName);
        }
        this.target.inject((Object)camelContext, context);
        this.target.postConstruct((Object)camelContext);
        context.push((Object)camelContext);
        return camelContext;
    }

    public void destroy(CdiCamelContext instance, CreationalContext<CdiCamelContext> context) {
        this.target.preDestroy((Object)instance);
        this.target.dispose((Object)instance);
        context.release();
    }

    public Set<Type> getTypes() {
        return new HashSet<Type>(Arrays.asList(Object.class, CamelContext.class, CdiCamelContext.class));
    }

    public Set<Annotation> getQualifiers() {
        return new HashSet<AnnotationLiteral>(Arrays.asList(new DefaultLiteral(), new AnyLiteral()));
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.target.getInjectionPoints();
    }

    public Class<?> getBeanClass() {
        return CdiCamelContext.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return new HashSet<Class<? extends Annotation>>();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getCamelContextName() {
        return this.camelContextName;
    }

    public void configureCamelContext(CdiCamelContext camelContext) {
        this.config.configure(camelContext, this.beanManager);
    }
}

