/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.ws;

import com.ning.http.client.ws.WebSocket;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ahc.ws.WsEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class WsProducer
extends DefaultProducer {
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 127;
    private int streamBufferSize = 127;

    public WsProducer(WsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public WsEndpoint getEndpoint() {
        return (WsEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Object message = in.getBody();
        this.log.debug("Sending out {}", message);
        if (message != null) {
            if (message instanceof String) {
                this.sendMessage(this.getWebSocket(), (String)message, this.getEndpoint().isUseStreaming());
            } else if (message instanceof byte[]) {
                this.sendMessage(this.getWebSocket(), (byte[])message, this.getEndpoint().isUseStreaming());
            } else if (message instanceof InputStream) {
                this.sendStreamMessage(this.getWebSocket(), (InputStream)message);
            } else {
                this.getWebSocket().sendMessage((String)in.getMandatoryBody(String.class));
            }
        }
    }

    private void sendMessage(WebSocket webSocket, String msg, boolean streaming) {
        if (streaming) {
            int p = 0;
            while (p < msg.length()) {
                if (msg.length() - p < this.streamBufferSize) {
                    webSocket.stream(msg.substring(p), true);
                    p = msg.length();
                    continue;
                }
                webSocket.stream(msg.substring(p, this.streamBufferSize), false);
                p += this.streamBufferSize;
            }
        } else {
            webSocket.sendMessage(msg);
        }
    }

    private void sendMessage(WebSocket webSocket, byte[] msg, boolean streaming) {
        if (streaming) {
            int p = 0;
            byte[] writebuf = new byte[this.streamBufferSize];
            while (p < msg.length) {
                if (msg.length - p < this.streamBufferSize) {
                    int rest = msg.length - p;
                    System.arraycopy(msg, p, writebuf, 0, rest);
                    byte[] tmpbuf = new byte[rest];
                    System.arraycopy(writebuf, 0, tmpbuf, 0, rest);
                    webSocket.stream(tmpbuf, 0, rest, true);
                    p = msg.length;
                    continue;
                }
                System.arraycopy(msg, p, writebuf, 0, this.streamBufferSize);
                webSocket.stream(writebuf, 0, this.streamBufferSize, false);
                p += this.streamBufferSize;
            }
        } else {
            webSocket.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStreamMessage(WebSocket webSocket, InputStream in) throws IOException {
        byte[] readbuf = new byte[this.streamBufferSize];
        byte[] writebuf = new byte[this.streamBufferSize];
        int rn = 0;
        int wn = 0;
        try {
            while ((rn = in.read(readbuf, 0, readbuf.length)) != -1) {
                if (wn > 0) {
                    webSocket.stream(writebuf, 0, writebuf.length, false);
                }
                System.arraycopy(readbuf, 0, writebuf, 0, rn);
                wn = rn;
            }
            if (wn < writebuf.length) {
                byte[] tmpbuf = writebuf;
                writebuf = new byte[wn];
                System.arraycopy(tmpbuf, 0, writebuf, 0, wn);
            }
            webSocket.stream(writebuf, 0, wn, true);
        }
        finally {
            in.close();
        }
    }

    private WebSocket getWebSocket() {
        return this.getEndpoint().getWebSocket();
    }
}

