/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora.utils;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.gora.GoraAttribute;
import org.apache.camel.component.gora.GoraConfiguration;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.store.DataStore;

public final class GoraUtils {
    private GoraUtils() {
    }

    public static Query<Object, Persistent> constractQueryFromConfiguration(DataStore<Object, Persistent> dataStore, GoraConfiguration conf) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Query query = dataStore.newQuery();
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_START_TIME, conf)) {
            query.setStartTime(GoraUtils.getAttributeAsLong(GoraAttribute.GORA_QUERY_START_TIME, conf).longValue());
        }
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_END_TIME, conf)) {
            query.setEndTime(GoraUtils.getAttributeAsLong(GoraAttribute.GORA_QUERY_END_TIME, conf).longValue());
        }
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_LIMIT, conf)) {
            query.setLimit(GoraUtils.getAttributeAsLong(GoraAttribute.GORA_QUERY_LIMIT, conf).longValue());
        }
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_TIME_RANGE_FROM, conf) && GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_TIME_RANGE_TO, conf)) {
            query.setTimeRange(GoraUtils.getAttributeAsLong(GoraAttribute.GORA_QUERY_TIME_RANGE_FROM, conf).longValue(), GoraUtils.getAttributeAsLong(GoraAttribute.GORA_QUERY_TIME_RANGE_TO, conf).longValue());
        }
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_TIMESTAMP, conf)) {
            query.setTimestamp(GoraUtils.getAttributeAsLong(GoraAttribute.GORA_QUERY_TIMESTAMP, conf).longValue());
        }
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_START_KEY, conf)) {
            query.setStartKey(GoraUtils.getAttribute(GoraAttribute.GORA_QUERY_START_KEY, conf));
        }
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_END_KEY, conf)) {
            query.setEndKey(GoraUtils.getAttribute(GoraAttribute.GORA_QUERY_END_KEY, conf));
        }
        if (GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_KEY_RANGE_FROM, conf) && GoraUtils.configurationExist(GoraAttribute.GORA_QUERY_KEY_RANGE_TO, conf)) {
            query.setKeyRange(GoraUtils.getAttribute(GoraAttribute.GORA_QUERY_KEY_RANGE_FROM, conf), GoraUtils.getAttribute(GoraAttribute.GORA_QUERY_KEY_RANGE_TO, conf));
        }
        return query;
    }

    public static Query<Object, Persistent> constractQueryFromPropertiesMap(Map<String, ?> propertiesMap, DataStore<Object, Persistent> dataStore, GoraConfiguration conf) throws ClassNotFoundException {
        Query query = dataStore.newQuery();
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_START_TIME, propertiesMap)) {
            query.setStartTime(GoraUtils.getPropertyAsLong(GoraAttribute.GORA_QUERY_START_TIME, propertiesMap).longValue());
        }
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_END_TIME, propertiesMap)) {
            query.setEndTime(GoraUtils.getPropertyAsLong(GoraAttribute.GORA_QUERY_END_TIME, propertiesMap).longValue());
        }
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_LIMIT, propertiesMap)) {
            query.setLimit(GoraUtils.getPropertyAsLong(GoraAttribute.GORA_QUERY_LIMIT, propertiesMap).longValue());
        }
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_TIME_RANGE_FROM, propertiesMap) && GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_TIME_RANGE_TO, propertiesMap)) {
            query.setTimeRange(GoraUtils.getPropertyAsLong(GoraAttribute.GORA_QUERY_TIME_RANGE_FROM, propertiesMap).longValue(), GoraUtils.getPropertyAsLong(GoraAttribute.GORA_QUERY_TIME_RANGE_TO, propertiesMap).longValue());
        }
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_TIMESTAMP, propertiesMap)) {
            query.setTimestamp(GoraUtils.getPropertyAsLong(GoraAttribute.GORA_QUERY_TIMESTAMP, propertiesMap).longValue());
        }
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_START_KEY, propertiesMap)) {
            query.setStartKey(GoraUtils.getProperty(GoraAttribute.GORA_QUERY_START_KEY, propertiesMap));
        }
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_END_KEY, propertiesMap)) {
            query.setStartKey(GoraUtils.getProperty(GoraAttribute.GORA_QUERY_END_KEY, propertiesMap));
        }
        if (GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_KEY_RANGE_FROM, propertiesMap) && GoraUtils.propertyExist(GoraAttribute.GORA_QUERY_KEY_RANGE_TO, propertiesMap)) {
            query.setKeyRange(GoraUtils.getProperty(GoraAttribute.GORA_QUERY_KEY_RANGE_FROM, propertiesMap), GoraUtils.getProperty(GoraAttribute.GORA_QUERY_KEY_RANGE_TO, propertiesMap));
        }
        return query;
    }

    protected static boolean configurationExist(GoraAttribute attr, GoraConfiguration conf) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return PropertyUtils.getSimpleProperty((Object)conf, (String)attr.value) != null;
    }

    protected static boolean propertyExist(GoraAttribute attr, Map<String, ?> propertiesMap) {
        return propertiesMap.containsKey(attr.value);
    }

    protected static Object getAttribute(GoraAttribute attr, GoraConfiguration conf) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return PropertyUtils.getSimpleProperty((Object)conf, (String)attr.value);
    }

    protected static String getAttributeAsString(GoraAttribute attr, GoraConfiguration conf) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return String.valueOf(GoraUtils.getAttribute(attr, conf));
    }

    protected static Long getAttributeAsLong(GoraAttribute attr, GoraConfiguration conf) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return Long.parseLong(GoraUtils.getAttributeAsString(attr, conf));
    }

    protected static Object getProperty(GoraAttribute attr, Map<String, ?> propertiesMap) {
        return propertiesMap.get(attr.value);
    }

    protected static String getPropertyAsString(GoraAttribute attr, Map<String, ?> propertiesMap) {
        return String.valueOf(GoraUtils.getProperty(attr, propertiesMap));
    }

    protected static Long getPropertyAsLong(GoraAttribute attr, Map<String, ?> propertiesMap) {
        return Long.parseLong(GoraUtils.getPropertyAsString(attr, propertiesMap));
    }

    public static Object getKeyFromExchange(Exchange exchange) {
        Object key = exchange.getIn().getHeader(GoraAttribute.GORA_KEY.value);
        Preconditions.checkNotNull((Object)key, (Object)"Key should not be null!");
        return key;
    }

    public static Persistent getValueFromExchange(Exchange exchange) {
        return (Persistent)exchange.getIn().getBody(Persistent.class);
    }
}

