/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.tools.apt.util.Func1;
import org.apache.camel.tools.apt.util.Strings;

@SupportedAnnotationTypes(value={"org.apache.camel.spi.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class EndpointAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(UriEndpoint.class);
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            this.processEndpointClass(roundEnv, (TypeElement)element);
        }
        return true;
    }

    protected void processEndpointClass(final RoundEnvironment roundEnv, final TypeElement classElement) {
        String scheme;
        final UriEndpoint uriEndpoint = classElement.getAnnotation(UriEndpoint.class);
        if (uriEndpoint != null && !Strings.isNullOrEmpty(scheme = uriEndpoint.scheme())) {
            String name = Strings.canonicalClassName(classElement.getQualifiedName().toString());
            String packageName = name.substring(0, name.lastIndexOf("."));
            String fileName = scheme + ".html";
            Func1<PrintWriter, Void> handler = new Func1<PrintWriter, Void>(){

                @Override
                public Void call(PrintWriter writer) {
                    EndpointAnnotationProcessor.this.writeHtmlDocumentation(writer, roundEnv, classElement, uriEndpoint);
                    return null;
                }
            };
            this.processFile(packageName, scheme, fileName, handler);
        }
    }

    protected void writeHtmlDocumentation(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, UriEndpoint uriEndpoint) {
        TypeElement consumerElement;
        writer.println("<html>");
        writer.println("<header>");
        String scheme = uriEndpoint.scheme();
        String title = scheme + " endpoint";
        writer.println("<title>" + title + "</title>");
        writer.println("</header>");
        writer.println("<body>");
        writer.println("<h1>" + title + "</h1>");
        this.showDocumentationAndFieldInjections(writer, roundEnv, classElement, "");
        TypeMirror consumerType = null;
        try {
            uriEndpoint.consumerClass();
        }
        catch (MirroredTypeException mte) {
            consumerType = mte.getTypeMirror();
        }
        boolean found = false;
        String consumerClassName = null;
        String consumerPrefix = Strings.getOrElse(uriEndpoint.consumerPrefix(), "");
        if (consumerType != null && (consumerElement = this.findTypeElement(roundEnv, consumerClassName = consumerType.toString())) != null) {
            writer.println("<h2>" + scheme + " consumer" + "</h2>");
            this.showDocumentationAndFieldInjections(writer, roundEnv, consumerElement, consumerPrefix);
            found = true;
        }
        if (!found && consumerClassName != null) {
            this.warning("APT could not find consumer class " + consumerClassName);
        }
        writer.println("</body>");
        writer.println("</html>");
    }

    protected void showDocumentationAndFieldInjections(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, String prefix) {
        String classDoc = this.processingEnv.getElementUtils().getDocComment(classElement);
        if (!Strings.isNullOrEmpty(classDoc)) {
            writer.println("<p>" + classDoc.trim() + "</p>");
        }
        TreeMap<String, List<String>> sortedMap = new TreeMap<String, List<String>>();
        this.findClassProperties(roundEnv, sortedMap, classElement, prefix);
        if (!sortedMap.isEmpty()) {
            writer.println("<table class='table'>");
            writer.println("  <tr>");
            writer.println("    <th>Name</th>");
            writer.println("    <th>Type</th>");
            writer.println("    <th>Description</th>");
            writer.println("  </tr>");
            Set entries = sortedMap.entrySet();
            for (Map.Entry entry : entries) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                writer.println("  <tr>");
                writer.println("    <td>" + name + "</td>");
                for (String value : values) {
                    writer.println(value);
                }
                writer.println("  </tr>");
            }
            writer.println("</table>");
        }
    }

    protected void findClassProperties(RoundEnvironment roundEnv, SortedMap<String, List<String>> sortedMap, TypeElement classElement, String prefix) {
        List<VariableElement> fieldElements;
        Elements elementUtils = this.processingEnv.getElementUtils();
        while (!(fieldElements = ElementFilter.fieldsIn(classElement.getEnclosedElements())).isEmpty()) {
            for (VariableElement fieldElement : fieldElements) {
                UriParam param = fieldElement.getAnnotation(UriParam.class);
                String fieldName = fieldElement.getSimpleName().toString();
                if (param == null) continue;
                String name = param.name();
                if (Strings.isNullOrEmpty(name)) {
                    name = fieldName;
                }
                name = prefix + name;
                TypeMirror fieldType = fieldElement.asType();
                String fieldTypeName = fieldType.toString();
                TypeElement fieldTypeElement = this.findTypeElement(roundEnv, fieldTypeName);
                UriParams fieldParams = null;
                if (fieldTypeElement != null) {
                    fieldParams = fieldTypeElement.getAnnotation(UriParams.class);
                }
                if (fieldParams != null) {
                    String nestedPrefix = prefix;
                    String extraPrefix = fieldParams.prefix();
                    if (!Strings.isNullOrEmpty(extraPrefix)) {
                        nestedPrefix = nestedPrefix + extraPrefix;
                    }
                    this.findClassProperties(roundEnv, sortedMap, fieldTypeElement, nestedPrefix);
                    continue;
                }
                String docComment = elementUtils.getDocComment(fieldElement);
                if (Strings.isNullOrEmpty(docComment)) {
                    String setter = "set" + fieldName.substring(0, 1).toUpperCase();
                    if (fieldName.length() > 1) {
                        setter = setter + fieldName.substring(1);
                    }
                    List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                    for (ExecutableElement method : methods) {
                        String doc;
                        String methodName = method.getSimpleName().toString();
                        if (!setter.equals(methodName) || method.getParameters().size() != 1 || Strings.isNullOrEmpty(doc = elementUtils.getDocComment(method))) continue;
                        docComment = doc;
                        break;
                    }
                }
                if (docComment == null) {
                    docComment = "";
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add("    <td>" + fieldTypeName + "</td>");
                values.add("    <td>" + docComment.trim() + "</td>");
                Object defaultValue = null;
                if (defaultValue != null) {
                    values.add("    <td>" + defaultValue + "</td>");
                }
                if (sortedMap.containsKey(name)) {
                    this.error("Duplicate parameter annotation named '" + name + "' on class " + classElement.getQualifiedName());
                    continue;
                }
                sortedMap.put(name, values);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = this.findTypeElement(roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    protected TypeElement findTypeElement(RoundEnvironment roundEnv, String className) {
        if (!Strings.isNullOrEmpty(className) && !"java.lang.Object".equals(className)) {
            Set<? extends Element> rootElements = roundEnv.getRootElements();
            for (Element element : rootElements) {
                TypeElement typeElement;
                String aRootName;
                if (!(element instanceof TypeElement) || !className.equals(aRootName = Strings.canonicalClassName((typeElement = (TypeElement)element).getQualifiedName().toString()))) continue;
                return typeElement;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(String packageName, String scheme, String fileName, Func1<PrintWriter, Void> handler) {
        PrintWriter writer = null;
        try {
            FileObject resource;
            FileWriter out = null;
            Filer filer = this.processingEnv.getFiler();
            try {
                resource = filer.getResource(StandardLocation.CLASS_OUTPUT, packageName, fileName);
            }
            catch (Throwable e) {
                resource = filer.createResource(StandardLocation.CLASS_OUTPUT, packageName, fileName, new Element[0]);
            }
            URI uri = resource.toUri();
            File file = null;
            if (uri != null) {
                try {
                    file = new File(uri.getPath());
                }
                catch (Exception e) {
                    this.warning("Could not convert output directory resource URI to a file " + e);
                }
            }
            if (file == null) {
                this.warning("No class output directory could be found!");
            } else {
                file.getParentFile().mkdirs();
                out = new FileWriter(file);
                writer = new PrintWriter(out);
                handler.call(writer);
            }
        }
        catch (IOException e) {
            this.log(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void log(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    protected void warning(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }

    protected void error(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    protected void log(Throwable e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        e.printStackTrace(writer);
        writer.close();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, buffer.toString());
    }
}

