/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.tools.apt.Func1;
import org.apache.camel.tools.apt.IOHelper;
import org.apache.camel.tools.apt.Strings;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor {
    protected String findJavaDoc(Elements elementUtils, Element element, String fieldName, String name, TypeElement classElement, boolean builderPattern) {
        String answer = null;
        if (element != null) {
            answer = elementUtils.getDocComment(element);
        }
        if (Strings.isNullOrEmpty(answer)) {
            String doc;
            ExecutableElement getter;
            String doc2;
            ExecutableElement setter = this.findSetter(fieldName, classElement);
            if (setter != null && !Strings.isNullOrEmpty(doc2 = elementUtils.getDocComment(setter))) {
                answer = doc2;
            }
            if (answer == null && (getter = this.findGetter(fieldName, classElement)) != null && !Strings.isNullOrEmpty(doc = elementUtils.getDocComment(getter))) {
                answer = doc;
            }
            if (answer == null && builderPattern) {
                String doc3;
                String methodName;
                List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                if (name != null) {
                    for (ExecutableElement method : methods) {
                        methodName = method.getSimpleName().toString();
                        if (!name.equals(methodName) || method.getParameters().size() != 1 || Strings.isNullOrEmpty(doc3 = elementUtils.getDocComment(method))) continue;
                        answer = doc3;
                        break;
                    }
                    for (ExecutableElement method : methods) {
                        methodName = method.getSimpleName().toString();
                        if (!name.equals(methodName) || method.getParameters().size() != 0 || Strings.isNullOrEmpty(doc3 = elementUtils.getDocComment(method))) continue;
                        answer = doc3;
                        break;
                    }
                }
                for (ExecutableElement method : methods) {
                    methodName = method.getSimpleName().toString();
                    if (!fieldName.equals(methodName) || method.getParameters().size() != 1 || Strings.isNullOrEmpty(doc3 = elementUtils.getDocComment(method))) continue;
                    answer = doc3;
                    break;
                }
                for (ExecutableElement method : methods) {
                    methodName = method.getSimpleName().toString();
                    if (!fieldName.equals(methodName) || method.getParameters().size() != 0 || Strings.isNullOrEmpty(doc3 = elementUtils.getDocComment(method))) continue;
                    answer = doc3;
                    break;
                }
            }
        }
        return answer;
    }

    protected ExecutableElement findSetter(String fieldName, TypeElement classElement) {
        String setter = "set" + fieldName.substring(0, 1).toUpperCase();
        if (fieldName.length() > 1) {
            setter = setter + fieldName.substring(1);
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        for (ExecutableElement method : methods) {
            String methodName = method.getSimpleName().toString();
            if (!setter.equals(methodName) || method.getParameters().size() != 1 || !method.getReturnType().getKind().equals((Object)TypeKind.VOID)) continue;
            return method;
        }
        return null;
    }

    protected ExecutableElement findGetter(String fieldName, TypeElement classElement) {
        String getter1 = "get" + fieldName.substring(0, 1).toUpperCase();
        if (fieldName.length() > 1) {
            getter1 = getter1 + fieldName.substring(1);
        }
        String getter2 = "is" + fieldName.substring(0, 1).toUpperCase();
        if (fieldName.length() > 1) {
            getter2 = getter2 + fieldName.substring(1);
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        for (ExecutableElement method : methods) {
            String methodName = method.getSimpleName().toString();
            if (!getter1.equals(methodName) && !getter2.equals(methodName) || method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    protected TypeElement findTypeElement(RoundEnvironment roundEnv, String className) {
        String packageName;
        PackageElement pe;
        if (Strings.isNullOrEmpty(className) || "java.lang.Object".equals(className)) {
            return null;
        }
        Set<? extends Element> rootElements = roundEnv.getRootElements();
        for (Element element : rootElements) {
            TypeElement typeElement;
            String aRootName;
            if (!(element instanceof TypeElement) || !className.equals(aRootName = Strings.canonicalClassName((typeElement = (TypeElement)element).getQualifiedName().toString()))) continue;
            return typeElement;
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        int n = className.lastIndexOf(46);
        if (n > 0 && (pe = elementUtils.getPackageElement(packageName = className.substring(0, n))) != null) {
            List<? extends Element> enclosedElements = pe.getEnclosedElements();
            for (Element element : enclosedElements) {
                TypeElement typeElement;
                String aRootName;
                if (!(element instanceof TypeElement) || !className.equals(aRootName = Strings.canonicalClassName((typeElement = (TypeElement)element).getQualifiedName().toString()))) continue;
                return typeElement;
            }
        }
        return null;
    }

    protected void findTypeElementChildren(RoundEnvironment roundEnv, Set<TypeElement> found, String superClassName) {
        String packageName;
        PackageElement pe;
        Elements elementUtils = this.processingEnv.getElementUtils();
        int idx = superClassName.lastIndexOf(46);
        if (idx > 0 && (pe = elementUtils.getPackageElement(packageName = superClassName.substring(0, idx))) != null) {
            List<? extends Element> enclosedElements = pe.getEnclosedElements();
            for (Element element : enclosedElements) {
                TypeElement typeElement;
                String aSuperClassName;
                if (!(element instanceof TypeElement) || !superClassName.equals(aSuperClassName = Strings.canonicalClassName((typeElement = (TypeElement)element).getSuperclass().toString()))) continue;
                found.add(typeElement);
            }
        }
    }

    protected boolean hasSuperClass(RoundEnvironment roundEnv, TypeElement classElement, String superClassName) {
        String aRootName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
        if (Strings.isNullOrEmpty(aRootName) || "java.lang.Object".equals(aRootName)) {
            return false;
        }
        String aSuperClassName = Strings.canonicalClassName(classElement.getSuperclass().toString());
        if (superClassName.equals(aSuperClassName)) {
            return true;
        }
        TypeElement aSuperClass = this.findTypeElement(roundEnv, aSuperClassName);
        if (aSuperClass != null) {
            return this.hasSuperClass(roundEnv, aSuperClass, superClassName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(String packageName, String fileName, Func1<PrintWriter, Void> handler) {
        try (PrintWriter writer = null;){
            FileObject resource;
            Filer filer = this.processingEnv.getFiler();
            try {
                resource = filer.getResource(StandardLocation.CLASS_OUTPUT, packageName, fileName);
            }
            catch (Throwable e) {
                resource = filer.createResource(StandardLocation.CLASS_OUTPUT, packageName, fileName, new Element[0]);
            }
            URI uri = resource.toUri();
            File file = null;
            if (uri != null) {
                try {
                    file = new File(uri.getPath());
                }
                catch (Exception e) {
                    this.warning("Could not convert output directory resource URI to a file " + e);
                }
            }
            if (file == null) {
                this.warning("No class output directory could be found!");
            } else {
                file.getParentFile().mkdirs();
                FileWriter out = new FileWriter(file);
                writer = new PrintWriter(out);
                handler.call(writer);
            }
        }
    }

    protected void log(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    protected void warning(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }

    protected void error(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    protected void log(Throwable e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        e.printStackTrace(writer);
        writer.close();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, buffer.toString());
    }

    protected String loadResource(String packageName, String fileName) {
        FileObject resource;
        Filer filer = this.processingEnv.getFiler();
        try {
            resource = filer.getResource(StandardLocation.CLASS_OUTPUT, "", packageName + "/" + fileName);
        }
        catch (Throwable e) {
            return "Crap" + e.getMessage();
        }
        if (resource == null) {
            return null;
        }
        try {
            InputStream is = resource.openInputStream();
            return IOHelper.loadText(is, true);
        }
        catch (Exception e) {
            this.warning("Could not load file");
            return null;
        }
    }
}

