/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ahc.AhcBinding;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.component.ahc.DefaultAhcBinding;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class AhcComponent
extends HeaderFilterStrategyComponent {
    private AsyncHttpClient client;
    private AsyncHttpClientConfig clientConfig;
    private AhcBinding binding;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String addressUri = remaining;
        AhcEndpoint endpoint = new AhcEndpoint(uri, this, null);
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        endpoint.setClient(this.getClient());
        endpoint.setClientConfig(this.getClientConfig());
        endpoint.setBinding(this.getBinding());
        this.setProperties((Object)endpoint, parameters);
        addressUri = UnsafeUriCharactersEncoder.encode((String)addressUri);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(addressUri), (Map)CastUtils.cast(parameters));
        endpoint.setHttpUri(httpUri);
        return endpoint;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public void setClient(AsyncHttpClient client) {
        this.client = client;
    }

    public AhcBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultAhcBinding();
        }
        return this.binding;
    }

    public void setBinding(AhcBinding binding) {
        this.binding = binding;
    }

    public AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }
}

