/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected static final String PREFIX = "org.apache.camel.";
    protected static final String OUT_PACKAGE = "org.apache.camel.component.internal";
    protected static final String COMPONENT_PACKAGE = "org.apache.camel.component";
    private static VelocityEngine engine;
    private static ClassLoader projectClassLoader;
    private static boolean sharedProjectState;
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    @Parameter(defaultValue="org.apache.camel.component.internal")
    protected String outPackage;
    @Parameter(required=true, property="org.apache.camel.scheme")
    protected String scheme;
    @Parameter(required=true, property="org.apache.camel.componentName")
    protected String componentName;
    @Parameter(required=true, defaultValue="org.apache.camel.component")
    protected String componentPackage;
    @Parameter(required=true, defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected AbstractGeneratorMojo() {
        AbstractGeneratorMojo.clearSharedProjectState();
    }

    public static void setSharedProjectState(boolean sharedProjectState) {
        AbstractGeneratorMojo.sharedProjectState = sharedProjectState;
    }

    protected static void clearSharedProjectState() {
        if (!sharedProjectState) {
            projectClassLoader = null;
        }
    }

    protected static VelocityEngine getEngine() {
        if (engine == null) {
            Properties velocityProperties = new Properties();
            velocityProperties.setProperty("resource.loader", "cloader");
            velocityProperties.setProperty("cloader.resource.loader.class", ClasspathResourceLoader.class.getName());
            velocityProperties.setProperty("runtime.log.logsystem.class", Log4JLogChute.class.getName());
            Logger velocityLogger = Logger.getLogger((String)"org.apache.camel.maven.Velocity");
            velocityProperties.setProperty("runtime.log.logsystem.log4j.logger", velocityLogger.getName());
            engine = new VelocityEngine(velocityProperties);
            engine.init();
        }
        return engine;
    }

    protected ClassLoader getProjectClassLoader() throws MojoExecutionException {
        if (projectClassLoader == null) {
            List classpathElements;
            try {
                classpathElements = this.project.getTestClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            URL[] urls = new URL[classpathElements.size()];
            int i = 0;
            Iterator it = classpathElements.iterator();
            while (it.hasNext()) {
                try {
                    urls[i] = new File((String)it.next()).toURI().toURL();
                    this.log.debug((Object)("Adding project path " + urls[i]));
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                ++i;
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            projectClassLoader = new URLClassLoader(urls, tccl != null ? tccl : ((Object)((Object)this)).getClass().getClassLoader());
        }
        return projectClassLoader;
    }

    protected void mergeTemplate(VelocityContext context, File outFile, String templateName) throws MojoExecutionException {
        File outDir = outFile.getParentFile();
        if (!outDir.isDirectory() && !outDir.mkdirs()) {
            throw new MojoExecutionException("Error creating directory " + outDir);
        }
        context.put("generatedDate", (Object)new Date().toString());
        context.put("packageName", (Object)this.outPackage);
        Template template = AbstractGeneratorMojo.getEngine().getTemplate(templateName, "UTF-8");
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(outFile));
            template.merge((Context)context, (Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (VelocityException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getCanonicalName(Class<?> type) {
        String canonicalName = type.getCanonicalName();
        int pkgEnd = canonicalName.lastIndexOf(46);
        if (pkgEnd > 0 && canonicalName.substring(0, pkgEnd).equals("java.lang")) {
            canonicalName = canonicalName.substring(pkgEnd + 1);
        }
        return canonicalName;
    }
}

