/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.camel.maven.AbstractGeneratorMojo;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.component.ApiCollection;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.ApiName;
import org.apache.commons.lang.ClassUtils;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.velocity.VelocityContext;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="document", requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, defaultPhase=LifecyclePhase.SITE)
public class DocumentGeneratorMojo
extends AbstractGeneratorMojo
implements MavenReport {
    @Parameter(property="org.apache.camel.reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}/cameldocs")
    private File reportOutputDirectory;
    @Parameter(property="org.apache.camel.destDir", defaultValue="cameldocs")
    private String destDir;
    @Parameter(property="name")
    private String name;
    @Parameter(property="description")
    private String description;
    private ApiCollection collection;

    public void execute() throws MojoExecutionException, MojoFailureException {
        RenderingContext context = new RenderingContext(this.reportOutputDirectory, this.getOutputName() + ".html");
        SiteRendererSink sink = new SiteRendererSink(context);
        Locale locale = Locale.getDefault();
        try {
            this.generate((Sink)sink, locale);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void loadApiCollection() throws MavenReportException {
        try {
            Class<?> collectionClass = this.getProjectClassLoader().loadClass(this.outPackage + "." + this.componentName + "ApiCollection");
            Method getCollection = collectionClass.getMethod("getCollection", new Class[0]);
            this.collection = (ApiCollection)getCollection.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private VelocityContext getDocumentContext() throws MavenReportException {
        Class<?> configClass;
        VelocityContext context = new VelocityContext();
        context.put("helper", (Object)this);
        context.put("groupId", (Object)this.project.getGroupId());
        context.put("artifactId", (Object)this.project.getArtifactId());
        context.put("version", (Object)this.project.getVersion());
        TreeSet apiNames = new TreeSet(this.collection.getApiNames());
        context.put("apiNames", apiNames);
        String suffix = apiNames.size() == 1 && apiNames.contains("") ? "://endpoint?[options]" : "://endpoint-prefix/endpoint?[options]";
        context.put("uriFormat", (Object)(this.scheme + suffix));
        TreeMap<String, ApiMethodHelper> apiHelpers = new TreeMap<String, ApiMethodHelper>();
        Iterator i$ = this.collection.getApiHelpers().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry element;
            Map.Entry entry = element = i$.next();
            apiHelpers.put(((ApiName)entry.getKey()).getName(), (ApiMethodHelper)entry.getValue());
        }
        context.put("apiHelpers", apiHelpers);
        TreeMap<String, Class> apiMethods = new TreeMap<String, Class>();
        TreeMap apiConfigs = new TreeMap();
        Iterator i$2 = this.collection.getApiMethods().entrySet().iterator();
        while (i$2.hasNext()) {
            Class<?> configClass2;
            Map.Entry element;
            Map.Entry entry = element = i$2.next();
            String name = ((ApiName)entry.getValue()).getName();
            Class apiMethod = (Class)entry.getKey();
            apiMethods.put(name, apiMethod);
            try {
                configClass2 = this.getProjectClassLoader().loadClass(this.getEndpointConfigName(apiMethod));
            }
            catch (ClassNotFoundException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
            apiConfigs.put(name, configClass2);
        }
        context.put("apiMethods", apiMethods);
        context.put("apiConfigs", apiConfigs);
        context.put("scheme", (Object)this.scheme);
        context.put("componentName", (Object)this.componentName);
        try {
            configClass = this.getProjectClassLoader().loadClass(this.getComponentConfig());
        }
        catch (ClassNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        context.put("componentConfig", configClass);
        TreeMap<String, String> configFields = new TreeMap<String, String>();
        do {
            IntrospectionSupport.ClassInfo classInfo = IntrospectionSupport.cacheClass(configClass);
            for (IntrospectionSupport.MethodInfo method : classInfo.methods) {
                if (!method.isSetter.booleanValue()) continue;
                configFields.put(method.getterOrSetterShorthandName, DocumentGeneratorMojo.getCanonicalName(method.method.getParameterTypes()[0]));
            }
        } while ((configClass = configClass.getSuperclass()) != null && !configClass.equals(Object.class));
        context.put("componentConfigFields", configFields);
        return context;
    }

    private String getComponentConfig() {
        StringBuilder builder = new StringBuilder(this.componentPackage);
        builder.append(".").append(this.componentName).append("Configuration");
        return builder.toString();
    }

    private String getEndpointConfigName(Class<? extends ApiMethod> apiMethod) {
        String simpleName = apiMethod.getSimpleName();
        StringBuilder builder = new StringBuilder(this.componentPackage);
        builder.append(".");
        builder.append(simpleName.substring(0, simpleName.indexOf("ApiMethod")));
        builder.append("EndpointConfiguration");
        return builder.toString();
    }

    private File getDocumentFile() {
        return new File(this.getReportOutputDirectory(), this.getDocumentName() + ".html");
    }

    private String getDocumentName() {
        return this.componentName + "Component";
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.loadApiCollection();
        try {
            this.mergeTemplate(this.getDocumentContext(), this.getDocumentFile(), "/api-document.vm");
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String getOutputName() {
        return this.destDir + "/" + this.getDocumentName();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.cameldoc.name");
        }
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.cameldoc.description");
        }
        return this.description;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = this.destDir != null && reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith(this.destDir) ? new File(reportOutputDirectory, this.destDir) : reportOutputDirectory;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.updateReportOutputDirectory(this.reportOutputDirectory);
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cameldoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public static List<EndpointInfo> getEndpoints(Class<? extends ApiMethod> apiMethod, ApiMethodHelper<?> helper, Class<?> endpointConfig) {
        Set<String> resultTypes;
        HashSet<String> validOptions = new HashSet<String>();
        for (Field field : endpointConfig.getDeclaredFields()) {
            validOptions.add(field.getName());
        }
        TreeMap<String, ArrayList<ApiMethod>> methodMap = new TreeMap<String, ArrayList<ApiMethod>>();
        for (ApiMethod method : apiMethod.getEnumConstants()) {
            String methodName = method.getName();
            ArrayList<ApiMethod> apiMethods = (ArrayList<ApiMethod>)methodMap.get(methodName);
            if (apiMethods == null) {
                apiMethods = new ArrayList<ApiMethod>();
                methodMap.put(methodName, apiMethods);
            }
            apiMethods.add(method);
        }
        TreeMap<String, TreeSet<String>> aliasMap = new TreeMap<String, TreeSet<String>>();
        Map aliasToMethodMap = helper.getAliases();
        for (Map.Entry entry : aliasToMethodMap.entrySet()) {
            String alias = (String)entry.getKey();
            for (String string : (Set)entry.getValue()) {
                TreeSet<String> aliases = (TreeSet<String>)aliasMap.get(string);
                if (aliases == null) {
                    aliases = new TreeSet<String>();
                    aliasMap.put(string, aliases);
                }
                aliases.add(alias);
            }
        }
        TreeMap optionMap = new TreeMap();
        TreeMap returnType = new TreeMap();
        for (Map.Entry entry : methodMap.entrySet()) {
            String string = (String)entry.getKey();
            List apiMethods = (List)entry.getValue();
            TreeMap<String, Integer> optionCount = new TreeMap<String, Integer>();
            resultTypes = new TreeSet();
            returnType.put(string, resultTypes);
            for (ApiMethod method : apiMethods) {
                for (String arg : method.getArgNames()) {
                    if (!validOptions.contains(arg)) continue;
                    Integer count = (Integer)optionCount.get(arg);
                    count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                    optionCount.put(arg, count);
                }
                Class resultType = method.getResultType();
                if (resultType.isPrimitive()) {
                    resultType = ClassUtils.primitiveToWrapper((Class)resultType);
                }
                ((TreeSet)resultTypes).add(DocumentGeneratorMojo.getCanonicalName(resultType));
            }
            TreeSet<String> options = new TreeSet<String>();
            optionMap.put(string, options);
            TreeSet<String> mandatory = new TreeSet<String>();
            int nMethods = apiMethods.size();
            for (ApiMethod method : apiMethods) {
                TreeSet<String> optional = new TreeSet<String>();
                for (String arg : method.getArgNames()) {
                    if (!validOptions.contains(arg)) continue;
                    Integer count = (Integer)optionCount.get(arg);
                    if (count == nMethods) {
                        mandatory.add(arg);
                        continue;
                    }
                    optional.add(arg);
                }
                if (optional.isEmpty()) continue;
                options.add(((Object)optional).toString());
            }
            if (mandatory.isEmpty()) continue;
            String mandatoryOptions = ((Object)mandatory).toString();
            options.add(mandatoryOptions.substring(1, mandatoryOptions.length() - 1));
        }
        ArrayList<EndpointInfo> infos = new ArrayList<EndpointInfo>();
        for (Map.Entry entry : methodMap.entrySet()) {
            String endpoint = (String)entry.getKey();
            EndpointInfo info = new EndpointInfo();
            info.endpoint = endpoint;
            info.aliases = DocumentGeneratorMojo.convertSetToString((Set)aliasMap.get(endpoint));
            info.options = DocumentGeneratorMojo.convertSetToString((Set)optionMap.get(endpoint));
            resultTypes = (Set)returnType.get(endpoint);
            resultTypes.remove("void");
            info.resultTypes = DocumentGeneratorMojo.convertSetToString(resultTypes);
            infos.add(info);
        }
        return infos;
    }

    private static String convertSetToString(Set<String> values) {
        if (values != null && !values.isEmpty()) {
            String result = values.toString();
            return result.substring(1, result.length() - 1);
        }
        return "";
    }

    public static String getCanonicalName(Field field) {
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType) {
            return DocumentGeneratorMojo.getCanonicalName((ParameterizedType)fieldType);
        }
        return DocumentGeneratorMojo.getCanonicalName(field.getType());
    }

    private static String getCanonicalName(ParameterizedType fieldType) {
        Type[] typeArguments = fieldType.getActualTypeArguments();
        int nArguments = typeArguments.length;
        if (nArguments > 0) {
            StringBuilder result = new StringBuilder(DocumentGeneratorMojo.getCanonicalName((Class)fieldType.getRawType()));
            result.append("&lt;");
            int i = 0;
            for (Type typeArg : typeArguments) {
                if (typeArg instanceof ParameterizedType) {
                    result.append(DocumentGeneratorMojo.getCanonicalName((ParameterizedType)typeArg));
                } else {
                    result.append(DocumentGeneratorMojo.getCanonicalName((Class)typeArg));
                }
                if (++i >= nArguments) continue;
                result.append(',');
            }
            result.append("&gt;");
            return result.toString();
        }
        return DocumentGeneratorMojo.getCanonicalName((Class)fieldType.getRawType());
    }

    public static class EndpointInfo {
        private String endpoint;
        private String aliases;
        private String options;
        private String resultTypes;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAliases() {
            return this.aliases;
        }

        public String getOptions() {
            return this.options;
        }

        public String getResultTypes() {
            return this.resultTypes;
        }
    }
}

