/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.atmos.AtmosConfiguration;
import org.apache.camel.component.atmos.AtmosEndpoint;
import org.apache.camel.component.atmos.util.AtmosOperation;
import org.apache.camel.component.atmos.util.AtmosPropertyManager;
import org.apache.camel.component.atmos.validator.AtmosConfigurationValidator;
import org.apache.camel.impl.UriEndpointComponent;

public class AtmosComponent
extends UriEndpointComponent {
    public AtmosComponent() {
        super(AtmosEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AtmosConfiguration configuration = new AtmosConfiguration();
        String name = null;
        String operation = remaining;
        String[] parts = remaining.split("/");
        if (parts.length > 1) {
            name = parts[0];
            operation = parts[1];
        }
        configuration.setName(name);
        configuration.setOperation(AtmosOperation.valueOf(operation));
        configuration.setUri(parameters.get("uri") == null ? AtmosPropertyManager.getInstance().getProperty("uri") : (String)parameters.get("uri"));
        configuration.setSecretKey(parameters.get("secretKey") == null ? AtmosPropertyManager.getInstance().getProperty("secretKey") : (String)parameters.get("secretKey"));
        configuration.setLocalPath((String)parameters.get("localPath"));
        configuration.setRemotePath((String)parameters.get("remotePath"));
        configuration.setNewRemotePath((String)parameters.get("newRemotePath"));
        configuration.setQuery((String)parameters.get("query"));
        configuration.setFullTokenId(parameters.get("fullTokenId") == null ? AtmosPropertyManager.getInstance().getProperty("fullTokenId") : (String)parameters.get("fullTokenId"));
        configuration.setEnableSslValidation(Boolean.parseBoolean(AtmosPropertyManager.getInstance().getProperty("sslValidation")));
        AtmosConfigurationValidator.validate(configuration);
        this.setProperties(configuration, parameters);
        AtmosEndpoint endpoint = new AtmosEndpoint(uri, this, configuration);
        return endpoint;
    }
}

