/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atmosphere.websocket.WebsocketEndpoint;
import org.apache.camel.component.atmosphere.websocket.WebsocketHandler;
import org.apache.camel.component.atmosphere.websocket.WebsocketStreamHandler;
import org.apache.camel.component.servlet.ServletConsumer;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketConsumer
extends ServletConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebsocketConsumer.class);
    private AtmosphereFramework framework = new AtmosphereFramework(false, true);

    public WebsocketConsumer(WebsocketEndpoint endpoint, Processor processor) {
        super((ServletEndpoint)endpoint, processor);
        this.framework.setUseNativeImplementation(false);
        this.framework.addInitParameter("org.atmosphere.useWebSocket", "true");
        this.framework.addInitParameter("org.atmosphere.websocket.WebSocketProtocol", endpoint.isUseStreaming() ? WebsocketStreamHandler.class.getName() : WebsocketHandler.class.getName());
        this.framework.init();
        WebSocketProtocol wsp = this.framework.getWebSocketProtocol();
        if (wsp instanceof WebsocketHandler) {
            ((WebsocketHandler)wsp).setConsumer(this);
        } else {
            LOG.error("unexpected WebSocketHandler: {}", (Object)wsp);
        }
    }

    public WebsocketEndpoint getEndpoint() {
        return (WebsocketEndpoint)super.getEndpoint();
    }

    void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.framework.doCometSupport(AtmosphereRequest.wrap((HttpServletRequest)request), AtmosphereResponse.wrap((HttpServletResponse)response));
    }

    public void sendMessage(String connectionKey, Object message) {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("websocket.connectionKey", (Object)connectionKey);
        exchange.getIn().setBody(message);
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    WebsocketConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }
}

