/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.specific.SpecificData;
import org.apache.camel.Exchange;
import org.apache.camel.component.avro.AvroConsumer;
import org.apache.camel.util.ExchangeHelper;

public class AvroResponder
extends SpecificResponder {
    private AvroConsumer consumer;

    public AvroResponder(AvroConsumer consumer) {
        super(consumer.getEndpoint().getProtocol(), null);
        this.consumer = consumer;
    }

    public Object respond(Protocol.Message message, Object request) throws Exception {
        int numParams = message.getRequest().getFields().size();
        Object[] params = new Object[numParams];
        Class[] paramTypes = new Class[numParams];
        int i = 0;
        for (Schema.Field param : message.getRequest().getFields()) {
            params[i] = ((GenericRecord)request).get(param.name());
            paramTypes[i] = SpecificData.get().getClass(param.schema());
            ++i;
        }
        Exchange exchange = this.consumer.getEndpoint().createExchange(message, params);
        try {
            this.consumer.getProcessor().process(exchange);
        }
        catch (Throwable e) {
            this.consumer.getExceptionHandler().handleException(e);
        }
        Object response = ExchangeHelper.isOutCapable((Exchange)exchange) ? exchange.getOut().getBody() : null;
        boolean failed = exchange.isFailed();
        if (failed) {
            response = exchange.getException() != null ? exchange.getException() : exchange.getOut().getBody();
        }
        return response;
    }
}

