/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.component.avro.AvroHttpEndpoint;
import org.apache.camel.component.avro.AvroNettyEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.URISupport;

public class AvroComponent
extends DefaultComponent {
    private AvroConfiguration configuration;

    public AvroComponent() {
    }

    public AvroComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AvroConfiguration config = this.configuration != null ? this.configuration.copy() : new AvroConfiguration();
        URI enpointUri = new URI(URISupport.normalizeUri((String)remaining));
        this.applyToConfiguration(config, enpointUri, parameters);
        if ("netty".equals(enpointUri.getScheme())) {
            return new AvroNettyEndpoint(remaining, (Component)this, config);
        }
        if ("http".equals(enpointUri.getScheme())) {
            return new AvroHttpEndpoint(remaining, (Component)this, config);
        }
        throw new IllegalArgumentException("Unknown avro scheme. Should use either netty or http.");
    }

    private void applyToConfiguration(AvroConfiguration config, URI endpointUri, Map<String, Object> parameters) throws Exception {
        Field f;
        Class protocolClass;
        config.parseURI(endpointUri, parameters, this);
        this.setProperties(config, parameters);
        if (config.getProtocol() == null && config.getProtocolClassName() != null && (protocolClass = this.getCamelContext().getClassResolver().resolveClass(config.getProtocolClassName())) != null && (f = protocolClass.getField("PROTOCOL")) != null) {
            Protocol protocol = (Protocol)f.get(null);
            config.setProtocol(protocol);
        }
        if (config.getProtocol() == null) {
            throw new IllegalArgumentException("Avro configuration does not contain protocol");
        }
    }

    public AvroConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AvroConfiguration configuration) {
        this.configuration = configuration;
    }
}

