/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.model;

import java.util.HashMap;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.camel.bam.model.EntitySupport;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.JpaTemplate;

@Entity
@Table(name="CAMEL_PROCESSDEFINITION", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class ProcessDefinition
extends EntitySupport {
    private static final transient Log LOG = LogFactory.getLog(ProcessDefinition.class);
    private String name;

    @Id
    @GeneratedValue
    public Long getId() {
        return super.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ProcessDefinition getRefreshedProcessDefinition(JpaTemplate template, ProcessDefinition definition) {
        ObjectHelper.notNull((Object)definition, (String)"definition");
        Long id = definition.getId();
        if (id == null) {
            LOG.warn((Object)"No primary key is available!");
            return ProcessDefinition.findOrCreateProcessDefinition(template, definition.getName());
        }
        definition = (ProcessDefinition)template.find(ProcessDefinition.class, (Object)id);
        return definition;
    }

    public static ProcessDefinition findOrCreateProcessDefinition(JpaTemplate template, String processName) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("processName", processName);
        List list = CastUtils.cast((List)template.findByNamedParams("select x from " + ProcessDefinition.class.getName() + " x where x.name = :processName", params));
        if (!list.isEmpty()) {
            return (ProcessDefinition)list.get(0);
        }
        ProcessDefinition answer = new ProcessDefinition();
        answer.setName(processName);
        template.persist((Object)answer);
        return answer;
    }
}

