/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.model;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessDefinition;
import org.apache.camel.bam.rules.ActivityRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="CAMEL_PROCESSINSTANCE")
public class ProcessInstance {
    private ProcessDefinition processDefinition;
    private Collection<ActivityState> activityStates = new HashSet<ActivityState>();
    private String correlationKey;
    private Date timeStarted;
    private Date timeCompleted;

    public ProcessInstance() {
        this.setTimeStarted(new Date());
    }

    public String toString() {
        return "ProcessInstance[" + this.getCorrelationKey() + "]";
    }

    @Id
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    @OneToMany(mappedBy="processInstance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public Collection<ActivityState> getActivityStates() {
        return this.activityStates;
    }

    public void setActivityStates(Collection<ActivityState> activityStates) {
        this.activityStates = activityStates;
    }

    @Transient
    public boolean isStarted() {
        return this.timeStarted != null;
    }

    @Transient
    public boolean isCompleted() {
        return this.timeCompleted != null;
    }

    @Temporal(value=TemporalType.TIME)
    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public void setTimeStarted(Date timeStarted) {
        this.timeStarted = timeStarted;
    }

    @Temporal(value=TemporalType.TIME)
    public Date getTimeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCompleted(Date timeCompleted) {
        this.timeCompleted = timeCompleted;
    }

    public ActivityState getActivityState(ActivityRules activityRules) {
        for (ActivityState activityState : this.getActivityStates()) {
            if (!activityState.isActivity(activityRules)) continue;
            return activityState;
        }
        return null;
    }

    public ActivityState getOrCreateActivityState(ActivityRules activityRules) {
        ActivityState state = this.getActivityState(activityRules);
        if (state == null) {
            state = this.createActivityState();
            state.setProcessInstance(this);
            state.setActivityDefinition(activityRules.getActivityDefinition());
        }
        return state;
    }

    protected ActivityState createActivityState() {
        return new ActivityState();
    }
}

