/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.processor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.bam.processor.NoCorrelationKeyException;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BamProcessorSupport<T>
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(BamProcessorSupport.class);
    private Class<T> entityType;
    private Expression correlationKeyExpression;
    private TransactionTemplate transactionTemplate;
    private int retryCount = 20;
    private long retrySleep = 1000L;

    protected BamProcessorSupport(TransactionTemplate transactionTemplate, Expression correlationKeyExpression) {
        Type argumentType;
        ParameterizedType parameterizedType;
        Type[] arguments;
        this.transactionTemplate = transactionTemplate;
        this.correlationKeyExpression = correlationKeyExpression;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (argumentType = arguments[0]) instanceof Class) {
            this.entityType = (Class)argumentType;
        }
        if (this.entityType == null) {
            throw new IllegalArgumentException("Could not infer the entity type!");
        }
    }

    protected BamProcessorSupport(TransactionTemplate transactionTemplate, Expression correlationKeyExpression, Class<T> entitytype) {
        this.transactionTemplate = transactionTemplate;
        this.entityType = entitytype;
        this.correlationKeyExpression = correlationKeyExpression;
    }

    public void process(final Exchange exchange) {
        for (int i = 1; i <= this.retryCount; ++i) {
            if (i > 1) {
                LOG.info((Object)("Retrying attempt: " + i));
                try {
                    Thread.sleep(this.retrySleep);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Caught: " + e), (Throwable)e);
                }
            }
            try {
                this.transactionTemplate.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        try {
                            Object key = BamProcessorSupport.this.getCorrelationKey(exchange);
                            Object entity = BamProcessorSupport.this.loadEntity(exchange, key);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Correlation key: " + key + " with entity: " + entity));
                            }
                            BamProcessorSupport.this.processEntity(exchange, entity);
                            return entity;
                        }
                        catch (Exception e) {
                            return BamProcessorSupport.this.onError(status, e);
                        }
                    }
                });
                if (i > 1) {
                    LOG.info((Object)("Attempt " + i + " worked!"));
                }
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to complete transaction: " + e), (Throwable)e);
                continue;
            }
        }
    }

    public Expression getCorrelationKeyExpression() {
        return this.correlationKeyExpression;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    protected abstract void processEntity(Exchange var1, T var2) throws Exception;

    protected abstract T loadEntity(Exchange var1, Object var2) throws Exception;

    protected abstract Class<?> getKeyType();

    protected Object getCorrelationKey(Exchange exchange) throws NoCorrelationKeyException {
        Class<?> keyType = this.getKeyType();
        Object value = keyType != null ? this.correlationKeyExpression.evaluate(exchange, keyType) : this.correlationKeyExpression.evaluate(exchange, Object.class);
        if (value == null) {
            throw new NoCorrelationKeyException(this, exchange);
        }
        return value;
    }

    protected Object onError(TransactionStatus status, Exception e) {
        status.setRollbackOnly();
        LOG.error((Object)("Caught: " + e), (Throwable)e);
        throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
    }
}

