/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.processor.JpaBamProcessorSupport;
import org.apache.camel.bam.processor.ProcessContext;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaBamProcessor
extends JpaBamProcessorSupport<ProcessInstance> {
    private static final transient Log LOG = LogFactory.getLog(JpaBamProcessor.class);

    public JpaBamProcessor(TransactionTemplate transactionTemplate, JpaTemplate template, Expression correlationKeyExpression, ActivityRules activityRules) {
        super(transactionTemplate, template, correlationKeyExpression, activityRules);
    }

    public JpaBamProcessor(TransactionTemplate transactionTemplate, JpaTemplate template, Expression correlationKeyExpression, ActivityRules activityRules, Class<ProcessInstance> entitytype) {
        super(transactionTemplate, template, correlationKeyExpression, activityRules, entitytype);
    }

    @Override
    protected void processEntity(Exchange exchange, ProcessInstance process) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing process instance: " + process));
        }
        ActivityRules rules = this.getActivityRules();
        ActivityState state = process.getOrCreateActivityState(rules);
        state.processExchange(rules, new ProcessContext(exchange, rules, state));
        rules.getProcessRules().processExchange(exchange, process);
    }
}

