/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.bam.ProcessBuilder;
import org.apache.camel.bam.model.ActivityDefinition;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.rules.ProcessRules;
import org.apache.camel.bam.rules.TemporalRule;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public class ActivityRules
extends ServiceSupport {
    private int expectedMessages = 1;
    private ProcessRules processRules;
    private List<TemporalRule> rules = new ArrayList<TemporalRule>();
    private String activityName;
    private final ProcessBuilder builder;

    public ActivityRules(ProcessBuilder builder) {
        this.builder = builder;
        this.processRules = builder.getProcessRules();
        this.processRules.getActivities().add(this);
    }

    public void addRule(TemporalRule rule) {
        this.rules.add(rule);
    }

    public void processExpired(ActivityState activityState) throws Exception {
        for (TemporalRule rule : this.rules) {
            rule.processExpired(activityState);
        }
    }

    public void processExchange(Exchange exchange, ProcessInstance process) {
        for (TemporalRule rule : this.rules) {
            rule.processExchange(exchange, process);
        }
    }

    public ActivityDefinition getActivityDefinition() {
        return this.builder.findOrCreateActivityDefinition(this.activityName);
    }

    public void setActivityDefinition(ActivityDefinition activityDefinition) {
    }

    public int getExpectedMessages() {
        return this.expectedMessages;
    }

    public void setExpectedMessages(int expectedMessages) {
        this.expectedMessages = expectedMessages;
    }

    public ProcessRules getProcessRules() {
        return this.processRules;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.rules);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.rules);
    }
}

