/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.camel.Exchange;
import org.apache.camel.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationException
extends ValidationException {
    private static final long serialVersionUID = 5767438583860347105L;
    private final Set<ConstraintViolation<Object>> constraintViolations;

    public BeanValidationException(Exchange exchange, Set<ConstraintViolation<Object>> constraintViolations, Object bean) {
        super(exchange, BeanValidationException.buildMessage(constraintViolations, bean));
        this.constraintViolations = constraintViolations;
    }

    protected static String buildMessage(Set<ConstraintViolation<Object>> constraintViolations, Object bean) {
        StringBuilder buffer = new StringBuilder("Validation failed for: ");
        buffer.append(bean);
        buffer.append(" errors: [");
        for (ConstraintViolation<Object> constraintViolation : constraintViolations) {
            buffer.append("property: " + constraintViolation.getPropertyPath() + "; value: " + constraintViolation.getInvalidValue() + "; constraint: " + constraintViolation.getMessage() + "; ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Set<ConstraintViolation<Object>> getConstraintViolations() {
        return this.constraintViolations;
    }
}

