/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.csv;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyAbstractDataFormat;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyCsvFactory;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyCsvDataFormat
extends BindyAbstractDataFormat {
    private static final transient Logger LOG = LoggerFactory.getLogger(BindyCsvDataFormat.class);

    public BindyCsvDataFormat() {
    }

    public BindyCsvDataFormat(String ... packages) {
        super(packages);
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        ArrayList models;
        BindyCsvFactory factory = (BindyCsvFactory)this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        byte[] bytesCRLF = Converter.getByteReturn(factory.getCarriageReturn());
        if (factory.getGenerateHeaderColumnNames()) {
            String result = factory.generateHeader();
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
        if (exchange.getContext().getTypeConverter().convertTo(List.class, body) == null) {
            models = new ArrayList();
            Iterator it = ObjectHelper.createIterator((Object)body);
            while (it.hasNext()) {
                Object e = it.next();
                String name = e.getClass().getName();
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put(name, body);
                models.add(row);
            }
        } else {
            models = (ArrayList)body;
        }
        for (Map map : models) {
            String result = factory.unbind(map);
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        BindyCsvFactory factory = (BindyCsvFactory)this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        InputStreamReader in = new InputStreamReader(inputStream);
        Scanner scanner = new Scanner(in);
        String separator = factory.getSeparator();
        ObjectHelper.notNull((Object)separator, (String)"The separator has not been defined in the annotation @CsvRecord or not instantiated during initModel.");
        int count = 0;
        try {
            if (factory.getSkipFirstLine() && scanner.hasNextLine()) {
                scanner.nextLine();
            }
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (ObjectHelper.isEmpty((Object)line)) continue;
                ++count;
                Map<String, Object> model = factory.factory();
                String[] tokens = line.split(separator, -1);
                List<String> result = Arrays.asList(tokens);
                if ((result = this.unquoteTokens(result)).size() == 0 || result.isEmpty()) {
                    throw new IllegalArgumentException("No records have been defined in the CSV");
                }
                if (result.size() <= 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Size of the record splitted : {}", (Object)result.size());
                }
                factory.bind(result, model, count);
                factory.link(model);
                models.add(model);
                LOG.debug("Graph of objects created: {}", model);
            }
            if (models.size() == 0) {
                throw new IllegalArgumentException("No records have been defined in the CSV");
            }
            ArrayList<Map<String, Object>> arrayList = models;
            return arrayList;
        }
        finally {
            scanner.close();
            IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
        }
    }

    private List<String> unquoteTokens(List<String> result) {
        ArrayList<String> answer = new ArrayList<String>(result.size());
        for (String s : result) {
            if (s.startsWith("\"") || s.startsWith("'")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"") || s.endsWith("'")) {
                s = s.substring(0, s.length() - 1);
            }
            answer.add(s);
        }
        return answer;
    }

    @Override
    protected BindyAbstractFactory createModelFactory(PackageScanClassResolver resolver) throws Exception {
        return new BindyCsvFactory(resolver, this.getPackages());
    }
}

