/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;

public class BlueprintContainerRegistry
implements Registry {
    private final BlueprintContainer blueprintContainer;

    public BlueprintContainerRegistry(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public Object lookup(String name) {
        try {
            return this.blueprintContainer.getComponentInstance(name);
        }
        catch (NoSuchComponentException e) {
            return null;
        }
    }

    public <T> T lookup(String name, Class<T> type) {
        Object answer;
        try {
            answer = this.blueprintContainer.getComponentInstance(name);
        }
        catch (NoSuchComponentException e) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        try {
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in BlueprintContainer: " + this.blueprintContainer + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return BlueprintContainerRegistry.lookupByType(this.blueprintContainer, type);
    }

    public static <T> Map<String, T> lookupByType(BlueprintContainer blueprintContainer, Class<T> type) {
        Bundle bundle = (Bundle)blueprintContainer.getComponentInstance("blueprintBundle");
        LinkedHashMap<String, T> objects = new LinkedHashMap<String, T>();
        Set ids = blueprintContainer.getComponentIds();
        for (String id : ids) {
            try {
                ComponentMetadata metadata = blueprintContainer.getComponentMetadata(id);
                Class cl = null;
                if (metadata instanceof BeanMetadata) {
                    BeanMetadata beanMetadata = (BeanMetadata)metadata;
                    cl = bundle.loadClass(beanMetadata.getClassName());
                } else if (metadata instanceof ReferenceMetadata) {
                    ReferenceMetadata referenceMetadata = (ReferenceMetadata)metadata;
                    cl = bundle.loadClass(referenceMetadata.getInterface());
                }
                if (cl == null || !type.isAssignableFrom(cl)) continue;
                Object o = blueprintContainer.getComponentInstance(metadata.getId());
                objects.put(metadata.getId(), type.cast(o));
            }
            catch (Throwable t) {}
        }
        return objects;
    }
}

