/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.List;
import java.util.Map;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.blueprint.BlueprintContainerRegistry;
import org.apache.camel.spi.PackageScanFilter;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextScanRouteBuilderFinder {
    private static final Logger LOG = LoggerFactory.getLogger(ContextScanRouteBuilderFinder.class);
    private final BlueprintContainer blueprintContainer;
    private final PackageScanFilter filter;

    public ContextScanRouteBuilderFinder(BlueprintCamelContext camelContext, PackageScanFilter filter) {
        this.blueprintContainer = camelContext.getBlueprintContainer();
        this.filter = filter;
    }

    public void appendBuilders(List<RoutesBuilder> list) {
        Map<String, RoutesBuilder> beans = BlueprintContainerRegistry.lookupByType(this.blueprintContainer, RoutesBuilder.class);
        for (Map.Entry<String, RoutesBuilder> entry : beans.entrySet()) {
            String key = entry.getKey();
            RoutesBuilder bean = entry.getValue();
            LOG.trace("Found RouteBuilder with id: {} -> {}", (Object)key, (Object)bean);
            if (this.shouldIgnoreBean(bean)) {
                LOG.debug("Ignoring RouteBuilder id: {}", (Object)key);
                continue;
            }
            if (!this.isFilteredClass(bean)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring filtered RouteBuilder id: {} as class: {}", (Object)key, bean.getClass());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding instantiated RouteBuilder id: {} as class: {}", (Object)key, bean.getClass());
            }
            list.add(bean);
        }
    }

    protected boolean shouldIgnoreBean(Object bean) {
        return false;
    }

    protected boolean isFilteredClass(Object bean) {
        if (this.filter != null) {
            return this.filter.matches(bean.getClass());
        }
        return false;
    }
}

