/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint.handler;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.camel.ExchangePattern;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.blueprint.CamelContextFactoryBean;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamespaceHandler
implements NamespaceHandler {
    private static final String CAMEL_CONTEXT = "camelContext";
    private static final String SPRING_NS = "http://camel.apache.org/schema/spring";
    private static final String BLUEPRINT_NS = "http://camel.apache.org/schema/blueprint";
    private static final transient Log LOG = LogFactory.getLog(CamelNamespaceHandler.class);
    private JAXBContext jaxbContext;

    public static void renameNamespaceRecursive(Node node) {
        if (node.getNodeType() == 1) {
            Document doc = node.getOwnerDocument();
            if (((Element)node).getNamespaceURI().equals(BLUEPRINT_NS)) {
                doc.renameNode(node, SPRING_NS, node.getNodeName());
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            CamelNamespaceHandler.renameNamespaceRecursive(list.item(i));
        }
    }

    public URL getSchemaLocation(String namespace) {
        return this.getClass().getClassLoader().getResource("camel-blueprint.xsd");
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(BlueprintCamelContext.class));
    }

    public Metadata parse(Element element, ParserContext context) {
        CamelNamespaceHandler.renameNamespaceRecursive(element);
        if (element.getNodeName().equals(CAMEL_CONTEXT)) {
            Binder binder;
            String contextId = element.getAttribute("id");
            if (ObjectHelper.isEmpty((Object)contextId)) {
                contextId = CAMEL_CONTEXT;
                element.setAttribute("id", contextId);
            }
            try {
                binder = this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new ComponentDefinitionException("Failed to create the JAXB binder : " + (Object)((Object)e), (Throwable)e);
            }
            Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
            if (!(value instanceof CamelContextFactoryBean)) {
                throw new ComponentDefinitionException("Expected an instance of " + CamelContextFactoryBean.class);
            }
            CamelContextFactoryBean ccfb = (CamelContextFactoryBean)((Object)value);
            try {
                PassThroughMetadata ptm = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintContainer");
                ccfb.setBlueprintContainer((BlueprintContainer)ptm.getObject());
                ptm = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintBundleContext");
                ccfb.setBundleContext((BundleContext)ptm.getObject());
                ccfb.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new ComponentDefinitionException("Unable to initialize camel context factory", (Throwable)e);
            }
            HashSet<String> components = new HashSet<String>();
            HashSet<String> languages = new HashSet<String>();
            HashSet<String> dataformats = new HashSet<String>();
            HashSet<String> dependsOn = new HashSet<String>();
            for (RouteDefinition rd : ((BlueprintCamelContext)((Object)ccfb.getContext())).getRouteDefinitions()) {
                this.findInputComponents(rd.getInputs(), components, languages, dataformats);
                this.findOutputComponents(rd.getOutputs(), components, languages, dataformats);
            }
            try {
                Bundle b;
                PassThroughMetadata ptm;
                MutableReferenceMetadata svc;
                ComponentMetadata cm;
                for (String component : components) {
                    cm = context.getComponentDefinitionRegistry().getComponentDefinition(".camelBlueprint.componentResolver." + component);
                    if (cm != null) continue;
                    svc = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
                    svc.setId(".camelBlueprint.componentResolver." + component);
                    svc.setFilter("(component=" + component + ")");
                    try {
                        svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, ComponentResolver.class);
                    }
                    catch (Throwable t) {
                        try {
                            ptm = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintBundle");
                            b = (Bundle)ptm.getObject();
                            if (b.loadClass(ComponentResolver.class.getName()) != ComponentResolver.class) {
                                throw new UnsupportedOperationException();
                            }
                            svc.setInterface(ComponentResolver.class.getName());
                        }
                        catch (Throwable t2) {
                            throw new UnsupportedOperationException();
                        }
                    }
                    context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)svc);
                    dependsOn.add(svc.getId());
                }
                for (String language : languages) {
                    cm = context.getComponentDefinitionRegistry().getComponentDefinition(".camelBlueprint.languageResolver." + language);
                    if (cm != null) continue;
                    svc = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
                    svc.setId(".camelBlueprint.languageResolver." + language);
                    svc.setFilter("(language=" + language + ")");
                    try {
                        svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, LanguageResolver.class);
                    }
                    catch (Throwable t) {
                        try {
                            ptm = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintBundle");
                            b = (Bundle)ptm.getObject();
                            if (b.loadClass(LanguageResolver.class.getName()) != LanguageResolver.class) {
                                throw new UnsupportedOperationException();
                            }
                            svc.setInterface(LanguageResolver.class.getName());
                        }
                        catch (Throwable t2) {
                            throw new UnsupportedOperationException();
                        }
                    }
                    context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)svc);
                    dependsOn.add(svc.getId());
                }
                for (String dataformat : dataformats) {
                    cm = context.getComponentDefinitionRegistry().getComponentDefinition(".camelBlueprint.dataformatResolver." + dataformat);
                    if (cm != null) continue;
                    svc = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
                    svc.setId(".camelBlueprint.dataformatResolver." + dataformat);
                    svc.setFilter("(dataformat=" + dataformat + ")");
                    try {
                        svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, DataFormatResolver.class);
                    }
                    catch (Throwable t) {
                        try {
                            ptm = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintBundle");
                            b = (Bundle)ptm.getObject();
                            if (b.loadClass(DataFormatResolver.class.getName()) != DataFormatResolver.class) {
                                throw new UnsupportedOperationException();
                            }
                            svc.setInterface(DataFormatResolver.class.getName());
                        }
                        catch (Throwable t2) {
                            throw new UnsupportedOperationException();
                        }
                    }
                    context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)svc);
                    dependsOn.add(svc.getId());
                }
            }
            catch (UnsupportedOperationException e) {
                LOG.warn((Object)"Unable to add dependencies on to camel components OSGi services.  The Apache Aries blueprint implementation used it too old and the blueprint bundle can not see the org.apache.camel.spi package.");
                components.clear();
                languages.clear();
                dataformats.clear();
            }
            MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
            factory.setId(".camelBlueprint.passThrough." + contextId);
            factory.setObject(new PassThroughCallable<Object>(value));
            factory.setDependsOn(new ArrayList<String>(components));
            MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            factory2.setId(".camelBlueprint.factory." + contextId);
            factory2.setFactoryComponent((Target)factory);
            factory2.setFactoryMethod("call");
            factory2.setDestroyMethod("destroy");
            MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            ctx.setId(contextId);
            ctx.setFactoryComponent((Target)factory2);
            ctx.setFactoryMethod("getContext");
            ctx.setInitMethod("init");
            ctx.setDestroyMethod("destroy");
            return ctx;
        }
        return null;
    }

    private void findInputComponents(List<FromDefinition> defs, Set<String> components, Set<String> languages, Set<String> dataformats) {
        if (defs != null) {
            for (FromDefinition def : defs) {
                this.findUriComponent(def.getUri(), components);
            }
        }
    }

    private void findOutputComponents(List<ProcessorDefinition> defs, Set<String> components, Set<String> languages, Set<String> dataformats) {
        if (defs != null) {
            for (ProcessorDefinition def : defs) {
                if (def instanceof SendDefinition) {
                    this.findUriComponent(((SendDefinition)def).getUri(), components);
                }
                if (def instanceof MarshalDefinition) {
                    this.findDataFormat(((MarshalDefinition)def).getDataFormatType(), dataformats);
                }
                if (def instanceof UnmarshalDefinition) {
                    this.findDataFormat(((UnmarshalDefinition)def).getDataFormatType(), dataformats);
                }
                if (def instanceof ExpressionNode) {
                    this.findLanguage(((ExpressionNode)def).getExpression(), languages);
                }
                if (def instanceof ResequenceDefinition) {
                    this.findLanguage(((ResequenceDefinition)def).getExpressions(), languages);
                }
                if (def instanceof AggregateDefinition) {
                    this.findLanguage(((AggregateDefinition)def).getExpression(), languages);
                    this.findLanguage(((AggregateDefinition)def).getCorrelationExpression(), languages);
                    this.findLanguage(((AggregateDefinition)def).getCompletionPredicate(), languages);
                    this.findLanguage(((AggregateDefinition)def).getCompletionTimeoutExpression(), languages);
                    this.findLanguage(((AggregateDefinition)def).getCompletionSizeExpression(), languages);
                }
                if (def instanceof CatchDefinition) {
                    this.findLanguage(((CatchDefinition)def).getHandled(), languages);
                }
                if (def instanceof OnExceptionDefinition) {
                    this.findLanguage(((OnExceptionDefinition)def).getRetryWhile(), languages);
                    this.findLanguage(((OnExceptionDefinition)def).getHandled(), languages);
                    this.findLanguage(((OnExceptionDefinition)def).getContinued(), languages);
                }
                if (def instanceof SortDefinition) {
                    this.findLanguage(((SortDefinition)def).getExpression(), languages);
                }
                if (def instanceof WireTapDefinition) {
                    this.findLanguage(((WireTapDefinition)def).getNewExchangeExpression(), languages);
                }
                this.findOutputComponents(def.getOutputs(), components, languages, dataformats);
            }
        }
    }

    private void findLanguage(ExpressionDefinition expression, Set<String> languages) {
        String lang;
        if (expression != null && (lang = expression.getLanguage()) != null && lang.length() > 0) {
            languages.add(lang);
        }
    }

    private void findLanguage(List<ExpressionDefinition> expressions, Set<String> languages) {
        if (expressions != null) {
            for (ExpressionDefinition e : expressions) {
                this.findLanguage(e, languages);
            }
        }
    }

    private void findLanguage(ExpressionSubElementDefinition expression, Set<String> languages) {
        if (expression != null) {
            this.findLanguage(expression.getExpressionType(), languages);
        }
    }

    private void findDataFormat(DataFormatDefinition dfd, Set<String> dataformats) {
        if (dfd != null && dfd.getDataFormatName() != null) {
            dataformats.add(dfd.getDataFormatName());
        }
    }

    private void findUriComponent(String uri, Set<String> components) {
        String[] splitURI;
        if (uri != null && (splitURI = ObjectHelper.splitOnCharacter((String)uri, (String)":", (int)2))[1] != null) {
            String scheme = splitURI[0];
            components.add(scheme);
        }
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return null;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext, Binder<Node> binder) {
        try {
            return binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to parse JAXB element: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = this.createJaxbContext();
        }
        return this.jaxbContext;
    }

    protected JAXBContext createJaxbContext() throws JAXBException {
        StringBuilder packages = new StringBuilder();
        for (Class cl : this.getJaxbPackages()) {
            if (packages.length() > 0) {
                packages.append(":");
            }
            packages.append(cl.getName().substring(0, cl.getName().lastIndexOf(46)));
        }
        return JAXBContext.newInstance((String)packages.toString(), (ClassLoader)this.getClass().getClassLoader());
    }

    protected Set<Class> getJaxbPackages() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(CamelContextFactoryBean.class);
        classes.add(AbstractCamelContextFactoryBean.class);
        classes.add(ExchangePattern.class);
        classes.add(RouteDefinition.class);
        classes.add(StreamResequencerConfig.class);
        classes.add(DataFormatsDefinition.class);
        classes.add(ExpressionDefinition.class);
        classes.add(RoundRobinLoadBalancerDefinition.class);
        return classes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PassThroughCallable<T>
    implements Callable<T> {
        private T value;

        public PassThroughCallable(T value) {
            this.value = value;
        }

        @Override
        public T call() throws Exception {
            return this.value;
        }
    }
}

