/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiClassResolver
extends DefaultClassResolver {
    private static final transient Log LOG = LogFactory.getLog(OsgiClassResolver.class);
    public BundleContext bundleContext;

    public OsgiClassResolver(BundleContext context) {
        this.bundleContext = context;
    }

    public Class<?> resolveClass(String name) {
        Class<?> clazz = ObjectHelper.loadSimpleType((String)(name = ObjectHelper.normalizeClassName((String)name)));
        if (clazz == null) {
            clazz = this.doLoadClass(name, this.bundleContext.getBundle());
        }
        return clazz;
    }

    public <T> Class<T> resolveClass(String name, Class<T> type) {
        return CastUtils.cast(this.resolveClass(name));
    }

    public InputStream loadResourceAsStream(String uri) {
        ObjectHelper.notEmpty((String)uri, (String)"uri");
        URL url = this.loadResourceAsURL(uri);
        InputStream answer = null;
        if (url != null) {
            try {
                answer = url.openStream();
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot load resource: " + uri, ex);
            }
        }
        return answer;
    }

    public URL loadResourceAsURL(String uri) {
        ObjectHelper.notEmpty((String)uri, (String)"uri");
        return this.bundleContext.getBundle().getEntry(uri);
    }

    protected Class<?> doLoadClass(String name, Bundle loader) {
        Class answer;
        block3: {
            ObjectHelper.notEmpty((String)name, (String)"name");
            answer = null;
            if (loader != null) {
                try {
                    answer = loader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace((Object)("Cannot load class: " + name + " using classloader: " + loader + ". This exception will be ignored."), (Throwable)e);
                }
            }
        }
        return answer;
    }
}

