/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Collections;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiTypeConverter
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry,
ServiceTrackerCustomizer {
    private static final Log LOG = LogFactory.getLog(OsgiTypeConverter.class);
    private final BundleContext bundleContext;
    private final Injector injector;
    private final ServiceTracker tracker;
    private volatile DefaultTypeConverter delegate;

    public OsgiTypeConverter(BundleContext bundleContext, Injector injector) {
        this.bundleContext = bundleContext;
        this.injector = injector;
        this.tracker = new ServiceTracker(bundleContext, TypeConverterLoader.class.getName(), (ServiceTrackerCustomizer)this);
    }

    public Object addingService(ServiceReference serviceReference) {
        TypeConverterLoader loader;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("AddingService: " + serviceReference));
        }
        if ((loader = (TypeConverterLoader)this.bundleContext.getService(serviceReference)) != null) {
            try {
                loader.load((TypeConverterRegistry)this.getDelegate());
            }
            catch (Throwable t) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)t);
            }
        }
        return loader;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
    }

    public void removedService(ServiceReference serviceReference, Object o) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("RemovedService: " + serviceReference));
        }
        this.delegate = null;
    }

    protected void doStart() throws Exception {
        this.tracker.open();
    }

    protected void doStop() throws Exception {
        this.tracker.close();
        this.delegate = null;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return (T)this.getDelegate().convertTo(type, value);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)this.getDelegate().convertTo(type, exchange, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return (T)this.getDelegate().mandatoryConvertTo(type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        return (T)this.getDelegate().mandatoryConvertTo(type, exchange, value);
    }

    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        this.getDelegate().addTypeConverter(toType, fromType, typeConverter);
    }

    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        this.getDelegate().addFallbackTypeConverter(typeConverter, canPromote);
    }

    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.getDelegate().lookup(toType, fromType);
    }

    public void setInjector(Injector injector) {
        this.getDelegate().setInjector(injector);
    }

    public Injector getInjector() {
        return this.getDelegate().getInjector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTypeConverter getDelegate() {
        if (this.delegate == null) {
            OsgiTypeConverter osgiTypeConverter = this;
            synchronized (osgiTypeConverter) {
                if (this.delegate != null) {
                    return this.delegate;
                }
                this.delegate = this.createRegistry();
            }
        }
        return this.delegate;
    }

    protected DefaultTypeConverter createRegistry() {
        DefaultTypeConverter reg = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(){

            public Set<ClassLoader> getClassLoaders() {
                return Collections.emptySet();
            }
        }, this.injector, null);
        Object[] services = this.tracker.getServices();
        if (services != null) {
            for (Object o : services) {
                try {
                    ((TypeConverterLoader)o).load((TypeConverterRegistry)reg);
                }
                catch (Throwable t) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)t);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Created TypeConverter: " + reg));
        }
        return reg;
    }
}

