/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private final Bundle bundle;

    public OsgiPackageScanClassResolver(BundleContext context) {
        this(context.getBundle());
    }

    public OsgiPackageScanClassResolver(Bundle bundle) {
        this.bundle = bundle;
        this.addClassLoader(new BundleDelegatingClassLoader(bundle));
    }

    public void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        int classesSize = classes.size();
        this.loadImplementationsInBundle(test, packageName, classes);
        if (classes.size() == classesSize) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Cannot find any classes in bundles, not trying regular classloaders scanning: " + packageName));
            }
            for (ClassLoader classLoader : super.getClassLoaders()) {
                if (OsgiPackageScanClassResolver.isOsgiClassloader(classLoader)) continue;
                this.find(test, packageName, classLoader, classes);
            }
        }
    }

    private static boolean isOsgiClassloader(ClassLoader loader) {
        try {
            Method mth = loader.getClass().getMethod("getBundle", new Class[0]);
            if (mth != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void loadImplementationsInBundle(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        Set<String> urls = this.getImplementationsInBundle(test, packageName);
        if (urls != null) {
            for (String url : urls) {
                this.addIfMatching(test, url, classes);
            }
        }
    }

    private Set<String> getImplementationsInBundle(PackageScanFilter test, String packageName) {
        Bundle[] bundles = this.bundle.getBundleContext() != null ? this.bundle.getBundleContext().getBundles() : new Bundle[]{this.bundle};
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        for (Bundle bd : bundles) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Searching in bundle:" + bd));
            }
            try {
                Enumeration paths = bd.findEntries("/" + packageName, "*.class", true);
                while (paths != null && paths.hasMoreElements()) {
                    URL path = (URL)paths.nextElement();
                    String pathString = path.getPath();
                    String urlString = pathString.substring(pathString.indexOf(packageName));
                    urls.add(urlString);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("Added url: " + urlString));
                }
            }
            catch (Throwable t) {
                this.log.warn((Object)("Cannot search in bundle: " + this.bundle + " for classes matching criteria: " + test + " due: " + t.getMessage() + ". This exception will be ignored."), t);
            }
        }
        return urls;
    }
}

