/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi.utils;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDelegatingClassLoader
extends ClassLoader {
    private static final transient Logger LOG = LoggerFactory.getLogger(BundleDelegatingClassLoader.class);
    private final Bundle bundle;
    private final ClassLoader classLoader;

    public BundleDelegatingClassLoader(Bundle bundle) {
        this(bundle, null);
    }

    public BundleDelegatingClassLoader(Bundle bundle, ClassLoader classLoader) {
        this.bundle = bundle;
        this.classLoader = classLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        LOG.trace("FindClass: {}", (Object)name);
        return this.bundle.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        LOG.trace("FindResource: {}", (Object)name);
        URL resource = this.bundle.getResource(name);
        if (this.classLoader != null && resource == null) {
            resource = this.classLoader.getResource(name);
        }
        return resource;
    }

    protected Enumeration findResources(String name) throws IOException {
        LOG.trace("FindResource: {}", (Object)name);
        return this.bundle.getResources(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        LOG.trace("LoadClass: {}, resolve: {}", (Object)name, (Object)resolve);
        try {
            clazz = this.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.classLoader != null) {
                try {
                    clazz = this.classLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException(name + " from bundle " + this.bundle.getBundleId() + " (" + this.bundle.getSymbolicName() + ")", cnfe);
                }
            }
            throw new ClassNotFoundException(name + " from bundle " + this.bundle.getBundleId() + " (" + this.bundle.getSymbolicName() + ")", cnfe);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String toString() {
        return String.format("BundleDelegatingClassLoader(%s)", this.bundle);
    }
}

