/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.blueprint.BlueprintCamelContextLookupHelper;
import org.apache.camel.blueprint.ErrorHandlerType;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.processor.RedeliveryPolicy;
import org.osgi.service.blueprint.container.BlueprintContainer;

@XmlRootElement(name="errorHandler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelErrorHandlerFactoryBean
extends AbstractCamelFactoryBean<ErrorHandlerBuilder> {
    @XmlAttribute
    private ErrorHandlerType type = ErrorHandlerType.DefaultErrorHandler;
    @XmlAttribute
    private String deadLetterUri;
    @XmlAttribute
    private LoggingLevel level = LoggingLevel.ERROR;
    @XmlAttribute
    private String logName;
    @XmlAttribute
    private Boolean useOriginalMessage;
    @XmlAttribute
    private String onRedeliveryRef;
    @XmlAttribute
    private String retryWhileRef;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private String redeliveryPolicyRef;
    @XmlElement
    private RedeliveryPolicyDefinition redeliveryPolicy;
    @XmlTransient
    private BlueprintContainer blueprintContainer;

    @Override
    public ErrorHandlerBuilder getObject() throws Exception {
        ErrorHandlerBuilder errorHandler = this.getObjectType().newInstance();
        if (errorHandler instanceof DefaultErrorHandlerBuilder) {
            DefaultErrorHandlerBuilder handler = (DefaultErrorHandlerBuilder)errorHandler;
            if (this.deadLetterUri != null) {
                handler.setDeadLetterUri(this.deadLetterUri);
            }
            if (this.useOriginalMessage != null) {
                handler.setUseOriginalMessage(this.useOriginalMessage.booleanValue());
            }
            if (this.redeliveryPolicy != null) {
                handler.setRedeliveryPolicy(this.redeliveryPolicy.createRedeliveryPolicy(this.getCamelContext(), null));
            }
            if (this.redeliveryPolicyRef != null) {
                handler.setRedeliveryPolicy(this.lookup(this.redeliveryPolicyRef, RedeliveryPolicy.class));
            }
            if (this.onRedeliveryRef != null) {
                handler.setOnRedelivery(this.lookup(this.onRedeliveryRef, Processor.class));
            }
            if (this.retryWhileRef != null) {
                handler.setRetryWhileRef(this.retryWhileRef);
            }
            if (this.executorServiceRef != null) {
                handler.setExecutorServiceRef(this.executorServiceRef);
            }
        } else if (errorHandler instanceof LoggingErrorHandlerBuilder) {
            LoggingErrorHandlerBuilder handler = (LoggingErrorHandlerBuilder)errorHandler;
            if (this.level != null) {
                handler.setLevel(this.level);
            }
            if (this.logName != null) {
                handler.setLogName(this.logName);
            }
        }
        return errorHandler;
    }

    @Override
    public Class<? extends ErrorHandlerBuilder> getObjectType() {
        return this.type.getTypeAsClass();
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    @Override
    protected CamelContext getCamelContextWithId(String camelContextId) {
        if (this.blueprintContainer != null) {
            return (CamelContext)this.blueprintContainer.getComponentInstance(camelContextId);
        }
        return null;
    }

    @Override
    protected CamelContext discoverDefaultCamelContext() {
        Set<String> ids;
        if (this.blueprintContainer != null && (ids = BlueprintCamelContextLookupHelper.lookupBlueprintCamelContext(this.blueprintContainer)).size() == 1) {
            return this.getCamelContextWithId(ids.iterator().next());
        }
        return null;
    }

    protected <T> T lookup(String name, Class<T> type) {
        return type.cast(this.blueprintContainer.getComponentInstance(name));
    }
}

