/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.boxjavalibv2.authorization.IAuthEvent;
import com.box.boxjavalibv2.authorization.IAuthFlowListener;
import com.box.boxjavalibv2.authorization.IAuthFlowMessage;
import com.box.boxjavalibv2.events.OAuthEvent;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginAuthFlowListener
implements IAuthFlowListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthFlowListener.class);
    private final Exception[] exception = new Exception[1];
    private final CountDownLatch latch;

    public LoginAuthFlowListener(CountDownLatch latch) {
        this.latch = latch;
    }

    public void onAuthFlowMessage(IAuthFlowMessage message) {
    }

    public void onAuthFlowException(Exception e) {
        this.exception[0] = e;
        LOG.warn(String.format("OAuth exception: %s", e.getMessage()), (Throwable)e);
        this.latch.countDown();
    }

    public void onAuthFlowEvent(IAuthEvent state, IAuthFlowMessage message) {
        if (state == OAuthEvent.OAUTH_CREATED) {
            LOG.debug("OAuth succeeded");
            this.latch.countDown();
        }
    }

    public Exception getException() {
        return this.exception[0];
    }
}

