/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxEventCollection;
import com.box.boxjavalibv2.dao.BoxRealTimeServer;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.requests.requestobjects.BoxEventRequestObject;
import com.box.boxjavalibv2.resourcemanagers.IBoxEventsManager;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.exceptions.BoxSDKException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.internal.CachedBoxClient;
import org.apache.camel.component.box.internal.EventCallback;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollingEventsManager {
    private static final Logger LOG = LoggerFactory.getLogger(LongPollingEventsManager.class);
    private static final String RETRY_TIMEOUT = "retry_timeout";
    private static final String MAX_RETRIES = "max_retries";
    private static final String MESSAGE = "message";
    private static final String NEW_CHANGE = "new_change";
    private static final String RECONNECT = "reconnect";
    private static final String OUT_OF_DATE = "out_of_date";
    private final CachedBoxClient cachedBoxClient;
    private final ExecutorService executorService;
    private final BasicHttpParams httpParams;
    private HttpClient httpClient;
    private Future<?> pollFuture;
    private HttpGet httpGet;
    private boolean done;

    public LongPollingEventsManager(CachedBoxClient boxClient, Map<String, Object> httpParams, ExecutorService executorService) {
        this.cachedBoxClient = boxClient;
        this.executorService = executorService;
        this.httpParams = new BasicHttpParams();
        HttpConnectionParams.setSoKeepalive((HttpParams)this.httpParams, (boolean)true);
        if (httpParams != null) {
            for (Map.Entry<String, Object> entry : httpParams.entrySet()) {
                this.httpParams.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void poll(long streamPosition, final String streamType, final int limit, final EventCallback callback) throws BoxServerException, AuthFatalFailureException, BoxRestException {
        final IBoxEventsManager eventsManager = this.cachedBoxClient.getBoxClient().getEventsManager();
        if (-1L == streamPosition) {
            streamPosition = this.getCurrentStreamPosition(eventsManager, streamPosition);
        }
        ObjectHelper.notNull((Object)streamPosition, (String)"streamPosition");
        ObjectHelper.notEmpty((String)streamType, (String)"streamType");
        ObjectHelper.notNull((Object)callback, (String)"eventCallback");
        this.httpClient = new DefaultHttpClient(this.cachedBoxClient.getClientConnectionManager(), (HttpParams)this.httpParams);
        LOG.info("Started event polling thread for " + this.cachedBoxClient);
        final long startStreamPosition = streamPosition;
        this.pollFuture = this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                ObjectMapper mapper = new ObjectMapper();
                long currentStreamPosition = startStreamPosition;
                BoxRealTimeServer realTimeServer = null;
                boolean retry = false;
                int retries = 0;
                int maxRetries = 1;
                while (!LongPollingEventsManager.this.done) {
                    try {
                        retry = false;
                        if (realTimeServer == null) {
                            realTimeServer = LongPollingEventsManager.this.getBoxRealTimeServer(currentStreamPosition, eventsManager);
                            int requestTimeout = Integer.parseInt(realTimeServer.getExtraData(LongPollingEventsManager.RETRY_TIMEOUT).toString());
                            HttpParams params = LongPollingEventsManager.this.httpClient.getParams();
                            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)(requestTimeout * 1000));
                            maxRetries = Integer.parseInt(realTimeServer.getExtraData(LongPollingEventsManager.MAX_RETRIES).toString());
                        }
                        LongPollingEventsManager.this.httpGet = LongPollingEventsManager.this.getPollRequest(realTimeServer.getUrl(), currentStreamPosition);
                        HttpResponse httpResponse = null;
                        try {
                            httpResponse = LongPollingEventsManager.this.httpClient.execute((HttpUriRequest)LongPollingEventsManager.this.httpGet, (HttpContext)null);
                        }
                        catch (SocketTimeoutException e) {
                            LOG.debug("Poll timed out, retrying for " + LongPollingEventsManager.this.cachedBoxClient);
                        }
                        if (httpResponse != null) {
                            StatusLine statusLine = httpResponse.getStatusLine();
                            if (statusLine != null && statusLine.getStatusCode() == 200) {
                                HttpEntity entity = httpResponse.getEntity();
                                Map rtsResponse = (Map)mapper.readValue(entity.getContent(), Map.class);
                                String message = (String)rtsResponse.get(LongPollingEventsManager.MESSAGE);
                                if (LongPollingEventsManager.NEW_CHANGE.equals(message)) {
                                    BoxEventRequestObject requestObject = BoxEventRequestObject.getEventsRequestObject((long)currentStreamPosition);
                                    requestObject.setStreamType(streamType);
                                    requestObject.setLimit(limit);
                                    BoxEventCollection events = eventsManager.getEvents(requestObject);
                                    callback.onEvent(events);
                                    currentStreamPosition = events.getNextStreamPosition();
                                } else if (LongPollingEventsManager.RECONNECT.equals(message) || LongPollingEventsManager.MAX_RETRIES.equals(message)) {
                                    LOG.debug("Long poll reconnect for " + LongPollingEventsManager.this.cachedBoxClient);
                                    realTimeServer = null;
                                } else {
                                    if (!LongPollingEventsManager.OUT_OF_DATE.equals(message)) throw new RuntimeCamelException("Unknown poll response " + message);
                                    LOG.debug("Long poll out of date for " + LongPollingEventsManager.this.cachedBoxClient);
                                    currentStreamPosition = LongPollingEventsManager.this.getCurrentStreamPosition(eventsManager, -1L);
                                    realTimeServer = null;
                                }
                            } else {
                                String msg = "Unknown error";
                                if (statusLine == null) throw new RuntimeCamelException(msg);
                                msg = String.format("Error polling events for %s: code=%s, message=%s", LongPollingEventsManager.this.cachedBoxClient, statusLine.getStatusCode(), statusLine.getReasonPhrase());
                                throw new RuntimeCamelException(msg);
                            }
                        }
                        retry = true;
                    }
                    catch (InterruptedException e) {
                        LOG.debug("Interrupted event polling thread for {}, exiting...", (Object)LongPollingEventsManager.this.cachedBoxClient);
                    }
                    catch (BoxSDKException e) {
                        callback.onException((Exception)((Object)e));
                    }
                    catch (RuntimeCamelException e) {
                        callback.onException((Exception)((Object)e));
                    }
                    catch (SocketException e) {
                        LOG.debug("Socket exception while event polling for {}", (Object)LongPollingEventsManager.this.cachedBoxClient);
                        retry = true;
                        realTimeServer = null;
                    }
                    catch (Exception e) {
                        callback.onException((Exception)((Object)new RuntimeCamelException("Error while polling for " + LongPollingEventsManager.this.cachedBoxClient + ": " + e.getMessage(), (Throwable)e)));
                    }
                    finally {
                        if (!retry) {
                            LongPollingEventsManager.this.done = true;
                            continue;
                        }
                        if (realTimeServer == null || ++retries <= maxRetries) continue;
                        realTimeServer = null;
                    }
                }
                LOG.info("Stopped event polling thread for " + LongPollingEventsManager.this.cachedBoxClient);
            }
        });
    }

    private long getCurrentStreamPosition(IBoxEventsManager eventsManager, long streamPosition) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxEventRequestObject requestObject = BoxEventRequestObject.getEventsRequestObject((long)streamPosition);
        BoxEventCollection events = eventsManager.getEvents(requestObject);
        streamPosition = events.getNextStreamPosition();
        return streamPosition;
    }

    public void stopPolling() throws Exception {
        if (!this.done) {
            this.done = true;
            if (this.httpGet != null && !this.httpGet.isAborted()) {
                this.httpGet.abort();
            }
            if (this.pollFuture.cancel(true)) {
                LOG.info("Stopped event polling for " + this.cachedBoxClient);
            } else {
                LOG.warn("Unable to stop event polling for " + this.cachedBoxClient);
            }
            this.httpClient = null;
            this.pollFuture = null;
        }
    }

    private BoxRealTimeServer getBoxRealTimeServer(long currentStreamPosition, IBoxEventsManager eventsManager) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxEventRequestObject optionsRequest = BoxEventRequestObject.getEventsRequestObject((long)currentStreamPosition);
        BoxCollection eventOptions = eventsManager.getEventOptions((BoxDefaultRequestObject)optionsRequest);
        ArrayList entries = eventOptions.getEntries();
        if (entries == null || entries.size() < 1 || !(entries.get(0) instanceof BoxRealTimeServer)) {
            throw new RuntimeCamelException("No Real Time Server from event options for " + this.cachedBoxClient);
        }
        return (BoxRealTimeServer)entries.get(0);
    }

    private HttpGet getPollRequest(String url, long currentStreamPosition) throws AuthFatalFailureException {
        HttpGet httpGet = new HttpGet(url + "&stream_position=" + currentStreamPosition);
        String accessToken = this.cachedBoxClient.getBoxClient().getAuthData().getAccessToken();
        httpGet.setHeader("Authorization", "Bearer " + accessToken);
        return httpGet;
    }
}

