/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.boxjavalibv2.dao.BoxEventCollection;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxEndpoint;
import org.apache.camel.component.box.internal.CachedBoxClient;
import org.apache.camel.component.box.internal.EventCallback;
import org.apache.camel.component.box.internal.LongPollingEventsManager;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiConsumerHelper;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.PropertyNamesInterceptor;
import org.apache.camel.util.component.ResultInterceptor;

public class BoxConsumer
extends DefaultConsumer
implements PropertyNamesInterceptor,
ResultInterceptor,
EventCallback {
    private static final String CALLBACK_PROPERTY = "callback";
    private final LongPollingEventsManager apiProxy;
    private final Map<String, Object> properties;
    private final ApiMethod apiMethod;
    private boolean splitResult = true;
    private CachedBoxClient cachedBoxClient;

    public BoxConsumer(BoxEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.apiMethod = ApiConsumerHelper.findMethod((AbstractApiEndpoint)endpoint, (PropertyNamesInterceptor)this);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(endpoint.getEndpointProperties());
        this.properties.put(CALLBACK_PROPERTY, this);
        this.cachedBoxClient = endpoint.getBoxClient();
        this.apiProxy = new LongPollingEventsManager(this.cachedBoxClient, ((BoxConfiguration)endpoint.getConfiguration()).getHttpParams(), endpoint.getExecutorService());
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        propertyNames.add(CALLBACK_PROPERTY);
    }

    @Override
    public void onEvent(BoxEventCollection events) throws Exception {
        this.log.debug("Processed {} events for {}", (Object)ApiConsumerHelper.getResultsProcessed((DefaultConsumer)this, (Object)events, (boolean)this.splitResult), (Object)this.cachedBoxClient);
    }

    @Override
    public void onException(Exception e) {
        this.getExceptionHandler().handleException((Throwable)ObjectHelper.wrapRuntimeCamelException((Throwable)e));
    }

    protected void doStart() throws Exception {
        super.doStart();
        ApiMethodHelper.invokeMethod((Object)this.apiProxy, (ApiMethod)this.apiMethod, this.properties);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.apiProxy.stopPolling();
    }

    public boolean isSplitResult() {
        return this.splitResult;
    }

    public void setSplitResult(boolean splitResult) {
        this.splitResult = splitResult;
    }

    public Object splitResult(Object result) {
        if (result instanceof BoxEventCollection && this.splitResult) {
            BoxEventCollection eventCollection = (BoxEventCollection)result;
            ArrayList entries = eventCollection.getEntries();
            return entries.toArray(new BoxTypedObject[entries.size()]);
        }
        return result;
    }

    public void interceptResult(Object result, Exchange resultExchange) {
        if (result instanceof BoxEventCollection) {
            BoxEventCollection boxEventCollection = (BoxEventCollection)result;
            resultExchange.getIn().setHeader("CamelBox.chunkSize", (Object)boxEventCollection.getChunkSize());
            resultExchange.getIn().setHeader("CamelBox.nextStreamPosition", (Object)boxEventCollection.getNextStreamPosition());
        }
    }
}

