/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.dao.BoxPreview;
import com.box.boxjavalibv2.dao.BoxThumbnail;
import com.box.boxjavalibv2.filetransfer.IFileTransferListener;
import com.box.boxjavalibv2.requests.requestobjects.BoxFileRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxImageRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemCopyRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxSharedLinkRequestObject;
import com.box.boxjavalibv2.resourcemanagers.IBoxFilesManager;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import com.box.restclientv2.requestsbase.BoxFileUploadRequestObject;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodImpl;

public enum IBoxFilesManagerApiMethod implements ApiMethod
{
    COPYFILE(BoxFile.class, "copyFile", String.class, "fileId", BoxItemCopyRequestObject.class, "itemCopyRequest"),
    CREATESHAREDLINK(BoxFile.class, "createSharedLink", String.class, "fileId", BoxSharedLinkRequestObject.class, "sharedLinkRequest"),
    DELETEFILE(Void.TYPE, "deleteFile", String.class, "fileId", BoxDefaultRequestObject.class, "defaultRequest"),
    DELETEFILEVERSION(Void.TYPE, "deleteFileVersion", String.class, "fileId", String.class, "versionId", BoxDefaultRequestObject.class, "defaultRequest"),
    DOWNLOADFILE(InputStream.class, "downloadFile", String.class, "fileId", BoxDefaultRequestObject.class, "defaultRequest"),
    DOWNLOADFILE_1(Void.TYPE, "downloadFile", String.class, "fileId", File.class, "destination", IFileTransferListener.class, "listener", BoxDefaultRequestObject.class, "defaultRequest"),
    DOWNLOADFILE_2(Void.TYPE, "downloadFile", String.class, "fileId", new OutputStream[0].getClass(), "outputStreams", IFileTransferListener.class, "listener", BoxDefaultRequestObject.class, "defaultRequest"),
    DOWNLOADTHUMBNAIL(InputStream.class, "downloadThumbnail", String.class, "fileId", String.class, "extension", BoxImageRequestObject.class, "imageRequest"),
    GETFILE(BoxFile.class, "getFile", String.class, "fileId", BoxDefaultRequestObject.class, "defaultRequest"),
    GETFILECOMMENTS(BoxCollection.class, "getFileComments", String.class, "fileId", BoxDefaultRequestObject.class, "defaultRequest"),
    GETFILEVERSIONS(List.class, "getFileVersions", String.class, "fileId", BoxDefaultRequestObject.class, "defaultRequest"),
    GETPREVIEW(BoxPreview.class, "getPreview", String.class, "fileId", String.class, "extension", BoxImageRequestObject.class, "imageRequest"),
    GETTHUMBNAIL(BoxThumbnail.class, "getThumbnail", String.class, "fileId", String.class, "extension", BoxImageRequestObject.class, "imageRequest"),
    PROMOTEOLDFILEVERSION(Void.TYPE, "promoteOldFileVersion", String.class, "fileId", String.class, "versionId"),
    UPDATEFILEINFO(BoxFile.class, "updateFileInfo", String.class, "fileId", BoxFileRequestObject.class, "fileRequest"),
    UPLOADFILE(BoxFile.class, "uploadFile", BoxFileUploadRequestObject.class, "fileUploadRequest"),
    UPLOADNEWVERSION(BoxFile.class, "uploadNewVersion", String.class, "fileId", BoxFileUploadRequestObject.class, "fileUploadRequest");

    private final ApiMethod apiMethod;

    private IBoxFilesManagerApiMethod(Class<?> resultType, String name, Object ... args) {
        this.apiMethod = new ApiMethodImpl(IBoxFilesManager.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

