/*
 * Camel ApiCollection generated by camel-api-component-maven-plugin
 * Generated on: Mon Mar 13 07:46:09 EDT 2017
 */
package org.apache.camel.component.box.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.IBoxCollaborationsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxCommentsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxEventsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxFilesManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxFoldersManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxGroupsManagerEndpointConfiguration;
import org.apache.camel.component.box.LongPollingEventsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxSearchManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxCommentsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxFilesManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxFoldersManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxSharedItemsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxUsersManagerEndpointConfiguration;

import org.apache.camel.util.component.ApiCollection;
import org.apache.camel.util.component.ApiMethodHelper;

/**
 * Camel {@link ApiCollection} for Box
 */
public final class BoxApiCollection extends ApiCollection<BoxApiName, BoxConfiguration> {

    private static BoxApiCollection collection;

    private BoxApiCollection() {
        final Map<String, String> aliases = new HashMap<String, String>();
        List<String> nullableArgs;

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.COLLABORATIONS, new ApiMethodHelper<IBoxCollaborationsManagerApiMethod>(IBoxCollaborationsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxCollaborationsManagerApiMethod.class, BoxApiName.COLLABORATIONS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.COMMENTS, new ApiMethodHelper<IBoxCommentsManagerApiMethod>(IBoxCommentsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxCommentsManagerApiMethod.class, BoxApiName.COMMENTS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.EVENTS, new ApiMethodHelper<IBoxEventsManagerApiMethod>(IBoxEventsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxEventsManagerApiMethod.class, BoxApiName.EVENTS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|update|upload|download)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.FILES, new ApiMethodHelper<IBoxFilesManagerApiMethod>(IBoxFilesManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFilesManagerApiMethod.class, BoxApiName.FILES);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.FOLDERS, new ApiMethodHelper<IBoxFoldersManagerApiMethod>(IBoxFoldersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFoldersManagerApiMethod.class, BoxApiName.FOLDERS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.GROUPS, new ApiMethodHelper<IBoxGroupsManagerApiMethod>(IBoxGroupsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxGroupsManagerApiMethod.class, BoxApiName.GROUPS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList();
        apis.put(BoxApiName.POLL_EVENTS, new ApiMethodHelper<LongPollingEventsManagerApiMethod>(LongPollingEventsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(LongPollingEventsManagerApiMethod.class, BoxApiName.POLL_EVENTS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.SEARCH, new ApiMethodHelper<IBoxSearchManagerApiMethod>(IBoxSearchManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxSearchManagerApiMethod.class, BoxApiName.SEARCH);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.SHARED_COMMENTS, new ApiMethodHelper<IBoxCommentsManagerApiMethod>(IBoxCommentsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxCommentsManagerApiMethod.class, BoxApiName.SHARED_COMMENTS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|update|upload|download)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.SHARED_FILES, new ApiMethodHelper<IBoxFilesManagerApiMethod>(IBoxFilesManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFilesManagerApiMethod.class, BoxApiName.SHARED_FILES);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.SHARED_FOLDERS, new ApiMethodHelper<IBoxFoldersManagerApiMethod>(IBoxFoldersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFoldersManagerApiMethod.class, BoxApiName.SHARED_FOLDERS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.SHARED_ITEMS, new ApiMethodHelper<IBoxSharedItemsManagerApiMethod>(IBoxSharedItemsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxSharedItemsManagerApiMethod.class, BoxApiName.SHARED_ITEMS);

        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|update|upload|download)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apis.put(BoxApiName.USERS, new ApiMethodHelper<IBoxUsersManagerApiMethod>(IBoxUsersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxUsersManagerApiMethod.class, BoxApiName.USERS);
    }

    public BoxConfiguration getEndpointConfiguration(BoxApiName apiName) {
        BoxConfiguration result = null;
        switch (apiName) {
        case COLLABORATIONS:
            result = new IBoxCollaborationsManagerEndpointConfiguration();
            break;
        case COMMENTS:
            result = new IBoxCommentsManagerEndpointConfiguration();
            break;
        case EVENTS:
            result = new IBoxEventsManagerEndpointConfiguration();
            break;
        case FILES:
            result = new IBoxFilesManagerEndpointConfiguration();
            break;
        case FOLDERS:
            result = new IBoxFoldersManagerEndpointConfiguration();
            break;
        case GROUPS:
            result = new IBoxGroupsManagerEndpointConfiguration();
            break;
        case POLL_EVENTS:
            result = new LongPollingEventsManagerEndpointConfiguration();
            break;
        case SEARCH:
            result = new IBoxSearchManagerEndpointConfiguration();
            break;
        case SHARED_COMMENTS:
            result = new IBoxCommentsManagerEndpointConfiguration();
            break;
        case SHARED_FILES:
            result = new IBoxFilesManagerEndpointConfiguration();
            break;
        case SHARED_FOLDERS:
            result = new IBoxFoldersManagerEndpointConfiguration();
            break;
        case SHARED_ITEMS:
            result = new IBoxSharedItemsManagerEndpointConfiguration();
            break;
        case USERS:
            result = new IBoxUsersManagerEndpointConfiguration();
            break;
        }
        return result;
    }

    public static synchronized BoxApiCollection getCollection() {
        if (collection == null) {
            collection = new BoxApiCollection();
        }
        return collection;
    }
}
