/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.artix.ds;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.Element;
import biz.c24.io.api.presentation.BinarySink;
import biz.c24.io.api.presentation.BinarySource;
import biz.c24.io.api.presentation.JavaClassSink;
import biz.c24.io.api.presentation.JavaClassSource;
import biz.c24.io.api.presentation.SAXSink;
import biz.c24.io.api.presentation.SAXSource;
import biz.c24.io.api.presentation.Sink;
import biz.c24.io.api.presentation.Source;
import biz.c24.io.api.presentation.TagValuePairSink;
import biz.c24.io.api.presentation.TextualSink;
import biz.c24.io.api.presentation.TextualSource;
import biz.c24.io.api.presentation.XMLSink;
import biz.c24.io.api.presentation.XMLSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.model.dataformat.ArtixDSContentType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class ArtixDSFormat
implements DataFormat {
    private Sink sink;
    private Source source;
    private Element element;
    private Class elementType;
    private ArtixDSContentType contentType;

    public ArtixDSFormat() {
    }

    public ArtixDSFormat(Element element) {
        this.element = element;
    }

    public ArtixDSFormat(Element element, Source source, Sink sink) {
        this.element = element;
        this.source = source;
        this.sink = sink;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ComplexDataObject dataObject = ExchangeHelper.convertToMandatoryType(exchange, ComplexDataObject.class, graph);
        Sink s = this.getSink(exchange);
        ObjectHelper.notNull(s, "sink or element");
        s.setOutputStream(stream);
        s.writeObject(dataObject);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        Source s = this.getSource(exchange);
        Element e = this.getElement();
        ObjectHelper.notNull(s, "source");
        ObjectHelper.notNull(e, "element");
        s.setInputStream(stream);
        return s.readObject(e);
    }

    public Source getSource(Exchange exchange) {
        if (this.source == null) {
            ArtixDSContentType content = this.getContentType();
            if (content != null) {
                if (content == ArtixDSContentType.Auto) {
                    return this.discoverSource(exchange);
                }
                this.source = this.createSource(content);
            }
            if (this.source == null) {
                this.source = this.getDefaultSource();
            }
        }
        return this.source;
    }

    public Sink getSink(Exchange exchange) {
        if (this.sink == null) {
            ArtixDSContentType content = this.getContentType();
            if (content != null) {
                if (content == ArtixDSContentType.Auto) {
                    return this.discoverSink(exchange);
                }
                this.sink = this.createSink(content);
            }
            if (this.sink == null) {
                this.sink = this.getDefaultSink();
            }
        }
        return this.sink;
    }

    public Element getElement() {
        Class type;
        if (this.element == null && (type = this.getElementType()) != null) {
            this.element = ObjectHelper.newInstance(type, Element.class);
        }
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Class getElementType() {
        return this.elementType;
    }

    public void setElementType(Class elementType) {
        this.elementType = elementType;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public ArtixDSContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ArtixDSContentType contentType) {
        this.contentType = contentType;
    }

    public Source getDefaultSource() {
        Element e = this.getElement();
        if (e != null) {
            return e.getModel().source();
        }
        return null;
    }

    public Sink getDefaultSink() {
        Element e = this.getElement();
        if (e != null) {
            return e.getModel().sink();
        }
        return null;
    }

    protected Source discoverSource(Exchange exchange) {
        String mime = ExchangeHelper.getContentType(exchange);
        if (mime != null) {
            if (this.isXmlMimeType(mime)) {
                return new XMLSource();
            }
            if (this.isJavaMimeType(mime)) {
                return new JavaClassSource();
            }
            if (this.isBinaryMimeType(mime)) {
                return new BinarySource();
            }
            if (this.isTextMimeType(mime)) {
                return new TextualSource();
            }
        }
        return this.getDefaultSource();
    }

    protected Source createSource(ArtixDSContentType content) {
        switch (content) {
            case Default: {
                return this.getDefaultSource();
            }
            case Binary: {
                return new BinarySource();
            }
            case Java: {
                return new JavaClassSource();
            }
            case Sax: {
                return new SAXSource();
            }
            case Text: {
                return new TextualSource();
            }
            case Xml: {
                return new XMLSource();
            }
        }
        throw new IllegalArgumentException("Unknown format type: " + (Object)((Object)content));
    }

    protected Sink discoverSink(Exchange exchange) {
        String mime = ExchangeHelper.getContentType(exchange);
        if (mime != null) {
            if (this.isXmlMimeType(mime)) {
                return new XMLSink();
            }
            if (this.isJavaMimeType(mime)) {
                return new JavaClassSink();
            }
            if (this.isBinaryMimeType(mime)) {
                return new BinarySink();
            }
            if (this.isTextMimeType(mime)) {
                return new TextualSink();
            }
        }
        return this.getDefaultSink();
    }

    protected Sink createSink(ArtixDSContentType content) {
        switch (content) {
            case Default: {
                return this.getDefaultSink();
            }
            case Binary: {
                return new BinarySink();
            }
            case Java: {
                return new JavaClassSink();
            }
            case Sax: {
                return new SAXSink();
            }
            case Text: {
                return new TextualSink();
            }
            case Xml: {
                return new XMLSink();
            }
            case TagValuePair: {
                return new TagValuePairSink();
            }
        }
        throw new IllegalArgumentException("Unknown format type: " + (Object)((Object)content));
    }

    protected boolean isXmlMimeType(String mime) {
        return mime.equals("application/xml") || mime.contains("xml");
    }

    protected boolean isJavaMimeType(String mime) {
        return mime.equals("application/x-java-serialized-object");
    }

    protected boolean isTextMimeType(String mime) {
        return mime.startsWith("text/");
    }

    protected boolean isBinaryMimeType(String mime) {
        return mime.equals("application/octet-stream");
    }
}

