/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.artix.ds;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.ValidationException;
import biz.c24.io.api.presentation.BinarySink;
import biz.c24.io.api.presentation.JavaClassSink;
import biz.c24.io.api.presentation.SAXSink;
import biz.c24.io.api.presentation.Sink;
import biz.c24.io.api.presentation.TagValuePairSink;
import biz.c24.io.api.presentation.TextualSink;
import biz.c24.io.api.presentation.XMLSink;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.artix.ds.ArtixDSSource;
import org.apache.camel.util.ExchangeHelper;

public class ArtixDSSink
extends ArtixDSSource {
    private Sink sink;

    public ArtixDSSink() {
    }

    public ArtixDSSink(Sink sink) {
        this.sink = sink;
    }

    public static ArtixDSSink adsSink() {
        return new ArtixDSSink();
    }

    public static ArtixDSSink adsSink(Sink sink) {
        return new ArtixDSSink(sink);
    }

    public void process(Exchange exchange) throws Exception {
        ComplexDataObject dataObject = this.unmarshalDataObject(exchange);
        dataObject = this.transformDataObject(exchange, dataObject);
        Sink s = this.getSink();
        if (s == null) {
            s = dataObject.getModel().sink();
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        s.setOutputStream((OutputStream)buffer);
        s.writeObject(dataObject);
        Message out = exchange.getOut(true);
        out.setHeader("org.apache.camel.artixds.sink", this.sink);
        out.setBody(buffer.toByteArray());
    }

    public Sink getSink() {
        return this.sink;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public ArtixDSSink text() {
        this.setSink((Sink)new TextualSink());
        return this;
    }

    public ArtixDSSink binary() {
        this.setSink((Sink)new BinarySink());
        return this;
    }

    public ArtixDSSink xml() {
        this.setSink((Sink)new XMLSink());
        return this;
    }

    public ArtixDSSink sax() {
        this.setSink((Sink)new SAXSink());
        return this;
    }

    public ArtixDSSink tagValuePair() {
        this.setSink((Sink)new TagValuePairSink());
        return this;
    }

    public ArtixDSSink java() {
        this.setSink((Sink)new JavaClassSink());
        return this;
    }

    protected ComplexDataObject unmarshalDataObject(Exchange exchange) throws InvalidPayloadException, IOException {
        return ExchangeHelper.getMandatoryInBody(exchange, ComplexDataObject.class);
    }

    protected ComplexDataObject transformDataObject(Exchange exchange, ComplexDataObject dataObject) throws ValidationException {
        return dataObject;
    }
}

