/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.artix.ds;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.Element;
import biz.c24.io.api.data.ValidationException;
import biz.c24.io.api.transform.Transform;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.artix.ds.ArtixDSSource;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtixDSTransform
implements Processor {
    private Transform transform;

    public ArtixDSTransform(Transform transform) {
        this.transform = transform;
    }

    public static ArtixDSTransform transform(Class<?> transformType) {
        Transform transformer = (Transform)ObjectHelper.newInstance(transformType);
        return ArtixDSTransform.transform(transformer);
    }

    public static ArtixDSTransform transform(Transform transformer) {
        return new ArtixDSTransform(transformer);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        ComplexDataObject[][] objects = null;
        ComplexDataObject dataObject = null;
        try {
            dataObject = exchange.getIn().getBody(ComplexDataObject.class);
        }
        catch (NoTypeConversionAvailableException e1) {
            try {
                objects = exchange.getIn().getBody(ComplexDataObject[][].class);
            }
            catch (NoTypeConversionAvailableException e2) {
                objects = this.getInBodyAsArray(exchange, objects);
            }
        }
        if (objects == null) {
            if (dataObject == null) {
                dataObject = this.unmarshalDataObject(exchange);
            }
            objects = new ComplexDataObject[][]{{dataObject}};
        }
        Object result = this.transform(objects);
        Message out = exchange.getOut();
        out.setBody(result);
    }

    private ComplexDataObject[][] getInBodyAsArray(Exchange exchange, ComplexDataObject[][] objects) {
        try {
            ComplexDataObject[] array = exchange.getIn().getBody(ComplexDataObject[].class);
            if (array != null) {
                objects = new ComplexDataObject[][]{array};
            }
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
        return objects;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    protected Object transform(ComplexDataObject[][] objects) throws ValidationException {
        Transform transformer = this.getTransform();
        ComplexDataObject[][] answer = transformer.transform(objects);
        return answer[0][0];
    }

    protected ComplexDataObject unmarshalDataObject(Exchange exchange) throws InvalidPayloadException, IOException {
        Transform transformer = this.getTransform();
        Element input = transformer.getInput(0);
        ArtixDSSource source = new ArtixDSSource(input);
        return source.parseDataObject(exchange);
    }
}

