/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.artix.ds;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.ValidationException;
import biz.c24.io.api.data.ValidationManager;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.artix.ds.ArtixDSValidationException;
import org.apache.camel.util.ExchangeHelper;

public class ArtixDSValidator
implements Processor {
    private ValidationManager validationManager;

    public void process(Exchange exchange) throws Exception {
        ComplexDataObject object = ExchangeHelper.getMandatoryInBody(exchange, ComplexDataObject.class);
        try {
            this.getValidationManager().validateByException(object);
        }
        catch (ValidationException e) {
            throw new ArtixDSValidationException(exchange, object, e);
        }
    }

    public ValidationManager getValidationManager() {
        if (this.validationManager == null) {
            this.validationManager = this.createValidationManager();
        }
        return this.validationManager;
    }

    public void setValidationManager(ValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    protected ValidationManager createValidationManager() {
        return new ValidationManager();
    }
}

