/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.artix.ds;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.data.Element;
import biz.c24.io.api.presentation.Sink;
import biz.c24.io.api.presentation.Source;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.artix.ds.ArtixDSHelper;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackTypeConverter
implements TypeConverter,
TypeConverterAware {
    private static final transient Log LOG = LogFactory.getLog(FallbackTypeConverter.class);
    private TypeConverter parentTypeConverter;
    private boolean prettyPrint = true;
    private Sink sink;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public void setTypeConverter(TypeConverter parentTypeConverter) {
        this.parentTypeConverter = parentTypeConverter;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, value, null);
    }

    public <T> T convertTo(Class<T> type, Object value, Exchange exchange) {
        try {
            if (this.isComplexDataObject(type)) {
                return this.unmarshall(type, value, exchange);
            }
            if (value instanceof ComplexDataObject) {
                this.marshall(type, (ComplexDataObject)value, exchange);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected <T> boolean isComplexDataObject(Class<T> type) {
        return type.isAssignableFrom(ComplexDataObject.class);
    }

    protected <T> T unmarshall(Class<T> type, Object value, Exchange exchange) throws IOException {
        Element element = this.getElementForType(type, exchange);
        if (element == null) {
            return null;
        }
        Source source = this.getSource(type, element, exchange);
        boolean configured = false;
        if (this.parentTypeConverter != null) {
            try {
                InputStream inputStream = this.parentTypeConverter.convertTo(InputStream.class, value);
                source.setInputStream(inputStream);
                configured = true;
            }
            catch (NoTypeConversionAvailableException ex1) {
                try {
                    Reader reader = this.parentTypeConverter.convertTo(Reader.class, value);
                    source.setReader(reader);
                    configured = true;
                }
                catch (NoTypeConversionAvailableException ex2) {
                    // empty catch block
                }
            }
            if (!configured) {
                if (value instanceof String) {
                    value = new StringReader((String)value);
                }
                if (value instanceof InputStream) {
                    source.setInputStream((InputStream)value);
                    configured = true;
                }
                if (value instanceof Reader) {
                    source.setReader((Reader)value);
                    configured = true;
                }
            }
        }
        if (configured) {
            ComplexDataObject object = source.readObject(element);
            return ObjectHelper.cast(type, object);
        }
        return null;
    }

    protected Element getElementForType(Class<?> type, Exchange exchange) {
        return ArtixDSHelper.getElement(type);
    }

    protected <T> T marshall(Class<T> type, ComplexDataObject dataObject, Exchange exchange) throws IOException {
        if (this.parentTypeConverter != null) {
            Sink sink = this.getSink(dataObject, exchange);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            sink.setOutputStream((OutputStream)buffer);
            sink.writeObject(dataObject);
            byte[] data = buffer.toByteArray();
            try {
                return this.parentTypeConverter.convertTo(type, data);
            }
            catch (NoTypeConversionAvailableException e) {
                return null;
            }
        }
        return null;
    }

    protected Source getSource(Class<?> type, Element element, Exchange exchange) {
        Source answer = null;
        if (exchange != null) {
            answer = exchange.getProperty("org.apache.camel.artixds.source", Source.class);
        }
        if (answer == null) {
            answer = element.getModel().source();
        }
        return answer;
    }

    protected Sink getSink(ComplexDataObject dataObject, Exchange exchange) {
        Sink answer = null;
        if (exchange != null) {
            answer = exchange.getProperty("org.apache.camel.artixds.sink", Sink.class);
        }
        if (answer == null) {
            answer = dataObject.getModel().sink();
        }
        return answer;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return this.convertTo(type, value, exchange);
    }
}

